/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;

final class BufferedResponseOutputStream
extends OutputStream {
    private final BufferAllocator allocator;
    private final Consumer<Buffer> responseBodyConsumer;

    BufferedResponseOutputStream(BufferAllocator allocator, Consumer<Buffer> responseBodyConsumer) {
        this.allocator = allocator;
        this.responseBodyConsumer = responseBodyConsumer;
    }

    @Override
    public void write(int b) {
        throw new UnsupportedOperationException("Only intended to be used with buffered responses");
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Buffer buf = this.allocator.newBuffer(len);
        buf.writeBytes(b, off, len);
        this.responseBodyConsumer.accept(buf);
    }
}

