/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.tiff.compression;

import java.io.ByteArrayOutputStream;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.tiff.compression.CompressionDecoder;
import mil.nga.tiff.compression.CompressionEncoder;
import mil.nga.tiff.io.ByteReader;
import mil.nga.tiff.util.TiffException;

public class LZWCompression
implements CompressionDecoder,
CompressionEncoder {
    private static final Logger logger = Logger.getLogger(LZWCompression.class.getName());
    private static final int CLEAR_CODE = 256;
    private static final int EOI_CODE = 257;
    private static final int MIN_BITS = 9;
    private Map<Integer, Integer[]> table = new HashMap<Integer, Integer[]>();
    private int maxCode;
    private int byteLength;
    private int position;

    @Override
    public byte[] decode(byte[] bytes, ByteOrder byteOrder) {
        ByteReader reader = new ByteReader(bytes, byteOrder);
        ByteArrayOutputStream decodedStream = new ByteArrayOutputStream();
        this.initializeTable();
        this.position = 0;
        int oldCode = 0;
        int code = this.getNextCode(reader);
        while (code != 257) {
            Integer[] value;
            if (code == 256) {
                this.initializeTable();
                code = this.getNextCode(reader);
                while (code == 256) {
                    code = this.getNextCode(reader);
                }
                if (code == 257) break;
                if (code > 256) {
                    throw new TiffException("Corrupted code at scan line: " + code);
                }
                value = this.table.get(code);
                this.writeValue(decodedStream, value);
                oldCode = code;
            } else {
                value = this.table.get(code);
                if (value != null) {
                    this.writeValue(decodedStream, value);
                    Integer[] newValue = this.concat(this.table.get(oldCode), this.table.get(code)[0]);
                    this.addToTable(newValue);
                    oldCode = code;
                } else {
                    Integer[] oldValue = this.table.get(oldCode);
                    Integer[] newValue = this.concat(oldValue, oldValue[0]);
                    this.writeValue(decodedStream, newValue);
                    this.addToTable(code, newValue);
                    oldCode = code;
                }
            }
            code = this.getNextCode(reader);
        }
        byte[] decoded = decodedStream.toByteArray();
        return decoded;
    }

    private void initializeTable() {
        this.table.clear();
        for (int i = 0; i <= 257; ++i) {
            this.table.put(i, new Integer[]{i});
        }
        this.maxCode = 257;
        this.byteLength = 9;
    }

    private void checkByteLength() {
        if ((double)this.maxCode >= Math.pow(2.0, this.byteLength) - 2.0) {
            ++this.byteLength;
        }
    }

    private void addToTable(Integer[] value) {
        this.addToTable(this.maxCode + 1, value);
    }

    private void addToTable(int code, Integer[] value) {
        this.table.put(code, value);
        this.maxCode = Math.max(this.maxCode, code);
        this.checkByteLength();
    }

    private Integer[] concat(Integer[] first, Integer second) {
        return this.concat(first, new Integer[]{second});
    }

    private Integer[] concat(Integer[] first, Integer[] second) {
        Integer[] combined = new Integer[first.length + second.length];
        System.arraycopy(first, 0, combined, 0, first.length);
        System.arraycopy(second, 0, combined, first.length, second.length);
        return combined;
    }

    private void writeValue(ByteArrayOutputStream decodedStream, Integer[] value) {
        for (int i = 0; i < value.length; ++i) {
            decodedStream.write(value[i]);
        }
    }

    private int getNextCode(ByteReader reader) {
        int nextByte = this.getByte(reader);
        this.position += this.byteLength;
        return nextByte;
    }

    private int getByte(ByteReader reader) {
        int d = this.position % 8;
        int a = (int)Math.floor((double)this.position / 8.0);
        int de = 8 - d;
        int ef = this.position + this.byteLength - (a + 1) * 8;
        int fg = 8 * (a + 2) - (this.position + this.byteLength);
        int dg = (a + 2) * 8 - this.position;
        fg = Math.max(0, fg);
        if (a >= reader.byteLength()) {
            logger.log(Level.WARNING, "End of data reached without an end of input code");
            return 257;
        }
        int chunk1 = reader.readUnsignedByte(a) & (int)(Math.pow(2.0, 8 - d) - 1.0);
        int chunks = chunk1 <<= this.byteLength - de;
        if (a + 1 < reader.byteLength()) {
            int chunk2 = reader.readUnsignedByte(a + 1) >>> fg;
            chunks += (chunk2 <<= Math.max(0, this.byteLength - dg));
        }
        if (ef > 8 && a + 2 < reader.byteLength()) {
            int hi = (a + 3) * 8 - (this.position + this.byteLength);
            int chunk3 = reader.readUnsignedByte(a + 2) >>> hi;
            chunks += chunk3;
        }
        return chunks;
    }

    @Override
    public boolean rowEncoding() {
        return false;
    }

    @Override
    public byte[] encode(byte[] bytes, ByteOrder byteOrder) {
        throw new TiffException("LZW encoder is not yet implemented");
    }
}

