/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import org.apache.baremaps.ogcapi.model.ExtentTemporalGridResolution;

@ApiModel(description="Provides information about the limited availability of data within the collection organized as a grid (regular or irregular) along the temporal dimension.")
@JsonTypeName(value="extent_temporal_grid")
public class ExtentTemporalGrid {
    @Valid
    private List<String> coordinates = null;
    @Valid
    private Integer cellsCount;
    @Valid
    private ExtentTemporalGridResolution resolution;

    public ExtentTemporalGrid coordinates(List<String> coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    @ApiModelProperty(value="List of coordinates along the temporal dimension for which data organized as an irregular grid in the collection is available (e.g., \"2017-11-14T09:00Z\",\"2017-11-14T12:00Z\",\"2017-11-14T15:00Z\",\"2017-11-14T18:00Z\",\"2017-11-14T21:00Z\").")
    @JsonProperty(value="coordinates")
    @Size(min=1)
    public @Size(min=1) List<String> getCoordinates() {
        return this.coordinates;
    }

    @JsonProperty(value="coordinates")
    public void setCoordinates(List<String> coordinates) {
        this.coordinates = coordinates;
    }

    public ExtentTemporalGrid addCoordinatesItem(String coordinatesItem) {
        if (this.coordinates == null) {
            this.coordinates = new ArrayList<String>();
        }
        this.coordinates.add(coordinatesItem);
        return this;
    }

    public ExtentTemporalGrid removeCoordinatesItem(String coordinatesItem) {
        if (coordinatesItem != null && this.coordinates != null) {
            this.coordinates.remove(coordinatesItem);
        }
        return this;
    }

    public ExtentTemporalGrid cellsCount(Integer cellsCount) {
        this.cellsCount = cellsCount;
        return this;
    }

    @ApiModelProperty(value="Number of samples available along the temporal dimension for data organized as a regular grid. For values representing the whole area of contiguous cells spanning _resolution_ units along the dimension, this will be (_upperBound_ - _lowerBound_) / _resolution_. For values representing infinitely small point cells spaced by _resolution_ units along the dimension, this will be (_upperBound_ - _lowerBound_) / _resolution_ + 1.")
    @JsonProperty(value="cellsCount")
    public Integer getCellsCount() {
        return this.cellsCount;
    }

    @JsonProperty(value="cellsCount")
    public void setCellsCount(Integer cellsCount) {
        this.cellsCount = cellsCount;
    }

    public ExtentTemporalGrid resolution(ExtentTemporalGridResolution resolution) {
        this.resolution = resolution;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="resolution")
    public ExtentTemporalGridResolution getResolution() {
        return this.resolution;
    }

    @JsonProperty(value="resolution")
    public void setResolution(ExtentTemporalGridResolution resolution) {
        this.resolution = resolution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtentTemporalGrid extentTemporalGrid = (ExtentTemporalGrid)o;
        return Objects.equals(this.coordinates, extentTemporalGrid.coordinates) && Objects.equals(this.cellsCount, extentTemporalGrid.cellsCount) && Objects.equals(this.resolution, extentTemporalGrid.resolution);
    }

    public int hashCode() {
        return Objects.hash(this.coordinates, this.cellsCount, this.resolution);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExtentTemporalGrid {\n");
        sb.append("    coordinates: ").append(this.toIndentedString(this.coordinates)).append("\n");
        sb.append("    cellsCount: ").append(this.toIndentedString(this.cellsCount)).append("\n");
        sb.append("    resolution: ").append(this.toIndentedString(this.resolution)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

