/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import org.apache.baremaps.ogcapi.model.VariableMatrixWidth;

@ApiModel(description="A tile matrix, usually corresponding to a particular zoom level of a TileMatrixSet.")
@JsonTypeName(value="tileMatrix")
public class TileMatrix {
    @Valid
    private String title;
    @Valid
    private String description;
    @Valid
    private List<String> keywords = null;
    @Valid
    private String id;
    @Valid
    private BigDecimal scaleDenominator;
    @Valid
    private BigDecimal cellSize;
    @Valid
    private CornerOfOriginEnum cornerOfOrigin = CornerOfOriginEnum.TOPLEFT;
    @Valid
    private Object pointOfOrigin;
    @Valid
    private BigDecimal tileWidth;
    @Valid
    private BigDecimal tileHeight;
    @Valid
    private BigDecimal matrixHeight;
    @Valid
    private BigDecimal matrixWidth;
    @Valid
    private List<VariableMatrixWidth> variableMatrixWidths = null;

    public TileMatrix title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Title of this tile matrix, normally used for display to a human")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public TileMatrix description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Brief narrative description of this tile matrix set, normally available for display to a human")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public TileMatrix keywords(List<String> keywords) {
        this.keywords = keywords;
        return this;
    }

    @ApiModelProperty(value="Unordered list of one or more commonly used or formalized word(s) or phrase(s) used to describe this dataset")
    @JsonProperty(value="keywords")
    public List<String> getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="keywords")
    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public TileMatrix addKeywordsItem(String keywordsItem) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(keywordsItem);
        return this;
    }

    public TileMatrix removeKeywordsItem(String keywordsItem) {
        if (keywordsItem != null && this.keywords != null) {
            this.keywords.remove(keywordsItem);
        }
        return this;
    }

    public TileMatrix id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifier selecting one of the scales defined in the TileMatrixSet and representing the scaleDenominator the tile. Implementation of 'identifier'")
    @JsonProperty(value="id")
    @NotNull
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public TileMatrix scaleDenominator(BigDecimal scaleDenominator) {
        this.scaleDenominator = scaleDenominator;
        return this;
    }

    @ApiModelProperty(required=true, value="Scale denominator of this tile matrix")
    @JsonProperty(value="scaleDenominator")
    @NotNull
    public BigDecimal getScaleDenominator() {
        return this.scaleDenominator;
    }

    @JsonProperty(value="scaleDenominator")
    public void setScaleDenominator(BigDecimal scaleDenominator) {
        this.scaleDenominator = scaleDenominator;
    }

    public TileMatrix cellSize(BigDecimal cellSize) {
        this.cellSize = cellSize;
        return this;
    }

    @ApiModelProperty(required=true, value="Cell size of this tile matrix")
    @JsonProperty(value="cellSize")
    @NotNull
    public BigDecimal getCellSize() {
        return this.cellSize;
    }

    @JsonProperty(value="cellSize")
    public void setCellSize(BigDecimal cellSize) {
        this.cellSize = cellSize;
    }

    public TileMatrix cornerOfOrigin(CornerOfOriginEnum cornerOfOrigin) {
        this.cornerOfOrigin = cornerOfOrigin;
        return this;
    }

    @ApiModelProperty(value="The corner of the tile matrix (_topLeft_ or _bottomLeft_) used as the origin for numbering tile rows and columns. This corner is also a corner of the (0, 0) tile.")
    @JsonProperty(value="cornerOfOrigin")
    public CornerOfOriginEnum getCornerOfOrigin() {
        return this.cornerOfOrigin;
    }

    @JsonProperty(value="cornerOfOrigin")
    public void setCornerOfOrigin(CornerOfOriginEnum cornerOfOrigin) {
        this.cornerOfOrigin = cornerOfOrigin;
    }

    public TileMatrix pointOfOrigin(Object pointOfOrigin) {
        this.pointOfOrigin = pointOfOrigin;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="pointOfOrigin")
    @NotNull
    public Object getPointOfOrigin() {
        return this.pointOfOrigin;
    }

    @JsonProperty(value="pointOfOrigin")
    public void setPointOfOrigin(Object pointOfOrigin) {
        this.pointOfOrigin = pointOfOrigin;
    }

    public TileMatrix tileWidth(BigDecimal tileWidth) {
        this.tileWidth = tileWidth;
        return this;
    }

    @ApiModelProperty(required=true, value="Width of each tile of this tile matrix in pixels")
    @JsonProperty(value="tileWidth")
    @NotNull
    @DecimalMin(value="1")
    public @NotNull @DecimalMin(value="1") BigDecimal getTileWidth() {
        return this.tileWidth;
    }

    @JsonProperty(value="tileWidth")
    public void setTileWidth(BigDecimal tileWidth) {
        this.tileWidth = tileWidth;
    }

    public TileMatrix tileHeight(BigDecimal tileHeight) {
        this.tileHeight = tileHeight;
        return this;
    }

    @ApiModelProperty(required=true, value="Height of each tile of this tile matrix in pixels")
    @JsonProperty(value="tileHeight")
    @NotNull
    @DecimalMin(value="1")
    public @NotNull @DecimalMin(value="1") BigDecimal getTileHeight() {
        return this.tileHeight;
    }

    @JsonProperty(value="tileHeight")
    public void setTileHeight(BigDecimal tileHeight) {
        this.tileHeight = tileHeight;
    }

    public TileMatrix matrixHeight(BigDecimal matrixHeight) {
        this.matrixHeight = matrixHeight;
        return this;
    }

    @ApiModelProperty(required=true, value="Width of the matrix (number of tiles in width)")
    @JsonProperty(value="matrixHeight")
    @NotNull
    @DecimalMin(value="1")
    public @NotNull @DecimalMin(value="1") BigDecimal getMatrixHeight() {
        return this.matrixHeight;
    }

    @JsonProperty(value="matrixHeight")
    public void setMatrixHeight(BigDecimal matrixHeight) {
        this.matrixHeight = matrixHeight;
    }

    public TileMatrix matrixWidth(BigDecimal matrixWidth) {
        this.matrixWidth = matrixWidth;
        return this;
    }

    @ApiModelProperty(required=true, value="Height of the matrix (number of tiles in height)")
    @JsonProperty(value="matrixWidth")
    @NotNull
    @DecimalMin(value="1")
    public @NotNull @DecimalMin(value="1") BigDecimal getMatrixWidth() {
        return this.matrixWidth;
    }

    @JsonProperty(value="matrixWidth")
    public void setMatrixWidth(BigDecimal matrixWidth) {
        this.matrixWidth = matrixWidth;
    }

    public TileMatrix variableMatrixWidths(List<VariableMatrixWidth> variableMatrixWidths) {
        this.variableMatrixWidths = variableMatrixWidths;
        return this;
    }

    @ApiModelProperty(value="Describes the rows that has variable matrix width")
    @JsonProperty(value="variableMatrixWidths")
    public List<VariableMatrixWidth> getVariableMatrixWidths() {
        return this.variableMatrixWidths;
    }

    @JsonProperty(value="variableMatrixWidths")
    public void setVariableMatrixWidths(List<VariableMatrixWidth> variableMatrixWidths) {
        this.variableMatrixWidths = variableMatrixWidths;
    }

    public TileMatrix addVariableMatrixWidthsItem(VariableMatrixWidth variableMatrixWidthsItem) {
        if (this.variableMatrixWidths == null) {
            this.variableMatrixWidths = new ArrayList<VariableMatrixWidth>();
        }
        this.variableMatrixWidths.add(variableMatrixWidthsItem);
        return this;
    }

    public TileMatrix removeVariableMatrixWidthsItem(VariableMatrixWidth variableMatrixWidthsItem) {
        if (variableMatrixWidthsItem != null && this.variableMatrixWidths != null) {
            this.variableMatrixWidths.remove(variableMatrixWidthsItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TileMatrix tileMatrix = (TileMatrix)o;
        return Objects.equals(this.title, tileMatrix.title) && Objects.equals(this.description, tileMatrix.description) && Objects.equals(this.keywords, tileMatrix.keywords) && Objects.equals(this.id, tileMatrix.id) && Objects.equals(this.scaleDenominator, tileMatrix.scaleDenominator) && Objects.equals(this.cellSize, tileMatrix.cellSize) && Objects.equals((Object)this.cornerOfOrigin, (Object)tileMatrix.cornerOfOrigin) && Objects.equals(this.pointOfOrigin, tileMatrix.pointOfOrigin) && Objects.equals(this.tileWidth, tileMatrix.tileWidth) && Objects.equals(this.tileHeight, tileMatrix.tileHeight) && Objects.equals(this.matrixHeight, tileMatrix.matrixHeight) && Objects.equals(this.matrixWidth, tileMatrix.matrixWidth) && Objects.equals(this.variableMatrixWidths, tileMatrix.variableMatrixWidths);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.title, this.description, this.keywords, this.id, this.scaleDenominator, this.cellSize, this.cornerOfOrigin, this.pointOfOrigin, this.tileWidth, this.tileHeight, this.matrixHeight, this.matrixWidth, this.variableMatrixWidths});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TileMatrix {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    scaleDenominator: ").append(this.toIndentedString(this.scaleDenominator)).append("\n");
        sb.append("    cellSize: ").append(this.toIndentedString(this.cellSize)).append("\n");
        sb.append("    cornerOfOrigin: ").append(this.toIndentedString((Object)this.cornerOfOrigin)).append("\n");
        sb.append("    pointOfOrigin: ").append(this.toIndentedString(this.pointOfOrigin)).append("\n");
        sb.append("    tileWidth: ").append(this.toIndentedString(this.tileWidth)).append("\n");
        sb.append("    tileHeight: ").append(this.toIndentedString(this.tileHeight)).append("\n");
        sb.append("    matrixHeight: ").append(this.toIndentedString(this.matrixHeight)).append("\n");
        sb.append("    matrixWidth: ").append(this.toIndentedString(this.matrixWidth)).append("\n");
        sb.append("    variableMatrixWidths: ").append(this.toIndentedString(this.variableMatrixWidths)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CornerOfOriginEnum {
        TOPLEFT(String.valueOf("topLeft")),
        BOTTOMLEFT(String.valueOf("bottomLeft"));

        private String value;

        private CornerOfOriginEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static CornerOfOriginEnum fromString(String s) {
            for (CornerOfOriginEnum b : CornerOfOriginEnum.values()) {
                if (!Objects.toString(b.value).equals(s)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected string value '" + s + "'");
        }

        @JsonCreator
        public static CornerOfOriginEnum fromValue(String value) {
            for (CornerOfOriginEnum b : CornerOfOriginEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

