/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.baremaps.ogcapi.model.Link;
import org.apache.baremaps.ogcapi.model.TileSetCrs;
import org.apache.baremaps.ogcapi.model.TileSetDataType;

@ApiModel(description="A minimal tileSet element for use within a list of tileSets linking to full description of those tileSets.")
@JsonTypeName(value="tileSet-item")
public class TileSetItem {
    @Valid
    private String title;
    @Valid
    private TileSetDataType dataType;
    @Valid
    private TileSetCrs crs;
    @Valid
    private URI tileMatrixSetURI;
    @Valid
    private List<Link> links = new ArrayList<Link>();

    public TileSetItem title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="A title for this tileSet")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public TileSetItem dataType(TileSetDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="dataType")
    @NotNull
    public TileSetDataType getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="dataType")
    public void setDataType(TileSetDataType dataType) {
        this.dataType = dataType;
    }

    public TileSetItem crs(TileSetCrs crs) {
        this.crs = crs;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="crs")
    @NotNull
    public TileSetCrs getCrs() {
        return this.crs;
    }

    @JsonProperty(value="crs")
    public void setCrs(TileSetCrs crs) {
        this.crs = crs;
    }

    public TileSetItem tileMatrixSetURI(URI tileMatrixSetURI) {
        this.tileMatrixSetURI = tileMatrixSetURI;
        return this;
    }

    @ApiModelProperty(value="Reference to a Tile Matrix Set on an offical source for Tile Matrix Sets such as the OGC NA definition server (http://www.opengis.net/def/tms/). Required if the tile matrix set is registered on an open official source.")
    @JsonProperty(value="tileMatrixSetURI")
    public URI getTileMatrixSetURI() {
        return this.tileMatrixSetURI;
    }

    @JsonProperty(value="tileMatrixSetURI")
    public void setTileMatrixSetURI(URI tileMatrixSetURI) {
        this.tileMatrixSetURI = tileMatrixSetURI;
    }

    public TileSetItem links(List<Link> links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(required=true, value="Links to related resources. A 'self' link to the tileSet as well as a 'http://www.opengis.net/def/rel/ogc/1.0/tiling-scheme' link to a definition of the TileMatrixSet are required.")
    @JsonProperty(value="links")
    @NotNull
    public List<Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public TileSetItem addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    public TileSetItem removeLinksItem(Link linksItem) {
        if (linksItem != null && this.links != null) {
            this.links.remove(linksItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TileSetItem tileSetItem = (TileSetItem)o;
        return Objects.equals(this.title, tileSetItem.title) && Objects.equals(this.dataType, tileSetItem.dataType) && Objects.equals(this.crs, tileSetItem.crs) && Objects.equals(this.tileMatrixSetURI, tileSetItem.tileMatrixSetURI) && Objects.equals(this.links, tileSetItem.links);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.dataType, this.crs, this.tileMatrixSetURI, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TileSetItem {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    dataType: ").append(this.toIndentedString(this.dataType)).append("\n");
        sb.append("    crs: ").append(this.toIndentedString(this.crs)).append("\n");
        sb.append("    tileMatrixSetURI: ").append(this.toIndentedString(this.tileMatrixSetURI)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

