/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import com.google.common.net.InetAddresses;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.transport.api.ConnectionContext;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.baremaps.iploc.IpLocObject;
import org.apache.baremaps.iploc.IpLocRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/")
public class IpLocResource {
    private static final Logger logger = LoggerFactory.getLogger(IpLocResource.class);
    private final IpLocRepository ipLocRepository;

    @Inject
    public IpLocResource(IpLocRepository ipLocRepository) {
        this.ipLocRepository = ipLocRepository;
    }

    @GET
    @Path(value="/api/ip")
    public Response ip(@Context ConnectionContext context, @Context StreamingHttpRequest request, @QueryParam(value="ip") String ip) {
        try {
            InetAddress address = InetAddresses.forString((String)((CharSequence)Optional.ofNullable(ip).or(() -> Optional.ofNullable(request.headers().get((CharSequence)"X-Forwarded-For"))).or(() -> Optional.ofNullable(request.headers().get((CharSequence)"X-Real-IP"))).orElse(((InetSocketAddress)context.remoteAddress()).getAddress().getHostAddress())).toString().split(",")[0].trim());
            return Response.status((int)200).header("Access-Control-Allow-Origin", (Object)"*").header("Content-Type", (Object)"application/json").entity((Object)new IP(address.toString())).build();
        }
        catch (IllegalArgumentException e) {
            logger.error("Error while processing request", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/api/iploc")
    public Response iploc(@Context ConnectionContext context, @Context StreamingHttpRequest request, @QueryParam(value="ip") String ip) {
        try {
            InetAddress address = InetAddresses.forString((String)((CharSequence)Optional.ofNullable(ip).or(() -> Optional.ofNullable(request.headers().get((CharSequence)"X-Forwarded-For"))).or(() -> Optional.ofNullable(request.headers().get((CharSequence)"X-Real-IP"))).orElse(((InetSocketAddress)context.remoteAddress()).getAddress().getHostAddress())).toString().split(",")[0].trim());
            List inetnumLocations = this.ipLocRepository.findByInetAddress(address);
            List<InetnumLocationDto> inetnumLocationDtos = inetnumLocations.stream().map(InetnumLocationDto::new).toList();
            return Response.status((int)200).header("Access-Control-Allow-Origin", (Object)"*").header("Content-Type", (Object)"application/json").entity(inetnumLocationDtos).build();
        }
        catch (IllegalArgumentException e) {
            logger.error("Error while processing request", (Throwable)e);
            return Response.serverError().build();
        }
    }

    public record IP(String ip) {
    }

    public record InetnumLocationDto(String geocoderInput, String inetStart, String inetEnd, double longitude, double latitude, String network, String country, String source, String precision) {
        public InetnumLocationDto(IpLocObject ipLocObject) {
            this(ipLocObject.geocoderInput(), ipLocObject.inetRange().start().toString().substring(1), ipLocObject.inetRange().end().toString().substring(1), ipLocObject.coordinate().getX(), ipLocObject.coordinate().getY(), ipLocObject.network(), ipLocObject.country(), ipLocObject.source(), ipLocObject.precision().toString());
        }
    }
}

