package org.apache.baremaps.ogcapi.api;

import org.apache.baremaps.ogcapi.model.Collection;
import org.apache.baremaps.ogcapi.model.Collections;

import javax.ws.rs.*;
import javax.ws.rs.core.Response;

import io.swagger.annotations.*;

import java.io.InputStream;
import java.util.Map;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/collections")
@Api(description = "the collections API")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public interface CollectionsApi {

    @GET
    @Path("/{collectionId}")
    @Produces({ "application/json" })
    @ApiOperation(value = "Retrieve the description of a collection available from this service.", notes = "", tags={ "Collections" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Information about a particular collection of (mostly geospatial) data available from this API. The collection is accessible via one or more OGC API set of specifications, for which a link to relevant accessible resources, e.g. /collections/{collectionId}/(items, coverage, map, tiles...) is contained in the response, with the corresponding relation type, as well as key information about the collection. This information includes: * a local identifier for the collection that is unique for the dataset; * a list of coordinate reference systems (CRS) in which data may be returned by the server. The first CRS is the default coordinate reference system (the default is always WGS 84 with axis order longitude/latitude); * an optional title and description for the collection; * an optional extent that can be used to provide an indication of the spatial and temporal extent of the collection - typically derived from the data; * for collections accessible via the Features or Records API, an optional indicator about the type of the items in the collection (the default value, if the indicator is not provided, is 'feature').", response = Collection.class) })
    Response getCollection(@PathParam("collectionId") @ApiParam("Local identifier of a collection") String collectionId);

    @GET
    @Produces({ "application/json" })
    @ApiOperation(value = "Retrieve the list of geospatial data collections available from this service.", notes = "", tags={ "Collections" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The collections of (mostly geospatial) data available from this API. The dataset contains one or more collections. This resource provides information about and access to the collections. The response contains the list of collections. Each collection is accessible via one or more OGC API set of specifications, for which a link to relevant accessible resources, e.g. /collections/{collectionId}/(items, coverage, map, tiles...) is provided, with the corresponding relation type, as well as key information about the collection. This information includes: * a local identifier for the collection that is unique for the dataset; * a list of coordinate reference systems (CRS) in which data may be returned by the server. The first CRS is the default coordinate reference system (the default is always WGS 84 with axis order longitude/latitude); * an optional title and description for the collection; * an optional extent that can be used to provide an indication of the spatial and temporal extent of the collection - typically derived from the data; * for collections accessible via the Features or Records API, an optional indicator about the type of the items in the collection (the default value, if the indicator is not provided, is 'feature').", response = Collections.class) })
    Response getCollections();
}
