package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.baremaps.ogcapi.model.LayersArrayPaint;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;



@JsonTypeName("layers-array")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class LayersArray   {
  private @Valid String id;
  public enum TypeEnum {

    FILL(String.valueOf("fill")), LINE(String.valueOf("line")), SYMBOL(String.valueOf("symbol")), CIRCLE(String.valueOf("circle")), HEATMAP(String.valueOf("heatmap")), FILL_EXTRUSION(String.valueOf("fill-extrusion")), RASTER(String.valueOf("raster")), HILLSHADE(String.valueOf("hillshade")), BACKGROUND(String.valueOf("background"));


    private String value;

    TypeEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Convert a String into String, as specified in the
     * <a href="https://download.oracle.com/otndocs/jcp/jaxrs-2_0-fr-eval-spec/index.html">See JAX RS 2.0 Specification, section 3.2, p. 12</a>
     */
	public static TypeEnum fromString(String s) {
        for (TypeEnum b : TypeEnum.values()) {
            // using Objects.toString() to be safe if value type non-object type
            // because types like 'int' etc. will be auto-boxed
            if (java.util.Objects.toString(b.value).equals(s)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected string value '" + s + "'");
	}
	
    @JsonCreator
    public static TypeEnum fromValue(String value) {
        for (TypeEnum b : TypeEnum.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

  private @Valid TypeEnum type;
  private @Valid String source;
  private @Valid String sourceLayer;
  private @Valid Object layout;
  private @Valid LayersArrayPaint paint;

  /**
   **/
  public LayersArray id(String id) {
    this.id = id;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("id")
  @NotNull
  public String getId() {
    return id;
  }

  @JsonProperty("id")
  public void setId(String id) {
    this.id = id;
  }

  /**
   **/
  public LayersArray type(TypeEnum type) {
    this.type = type;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("type")
  @NotNull
  public TypeEnum getType() {
    return type;
  }

  @JsonProperty("type")
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   **/
  public LayersArray source(String source) {
    this.source = source;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("source")
  public String getSource() {
    return source;
  }

  @JsonProperty("source")
  public void setSource(String source) {
    this.source = source;
  }

  /**
   **/
  public LayersArray sourceLayer(String sourceLayer) {
    this.sourceLayer = sourceLayer;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("source-layer")
  public String getSourceLayer() {
    return sourceLayer;
  }

  @JsonProperty("source-layer")
  public void setSourceLayer(String sourceLayer) {
    this.sourceLayer = sourceLayer;
  }

  /**
   **/
  public LayersArray layout(Object layout) {
    this.layout = layout;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("layout")
  public Object getLayout() {
    return layout;
  }

  @JsonProperty("layout")
  public void setLayout(Object layout) {
    this.layout = layout;
  }

  /**
   **/
  public LayersArray paint(LayersArrayPaint paint) {
    this.paint = paint;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("paint")
  public LayersArrayPaint getPaint() {
    return paint;
  }

  @JsonProperty("paint")
  public void setPaint(LayersArrayPaint paint) {
    this.paint = paint;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LayersArray layersArray = (LayersArray) o;
    return Objects.equals(this.id, layersArray.id) &&
        Objects.equals(this.type, layersArray.type) &&
        Objects.equals(this.source, layersArray.source) &&
        Objects.equals(this.sourceLayer, layersArray.sourceLayer) &&
        Objects.equals(this.layout, layersArray.layout) &&
        Objects.equals(this.paint, layersArray.paint);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, type, source, sourceLayer, layout, paint);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LayersArray {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    sourceLayer: ").append(toIndentedString(sourceLayer)).append("\n");
    sb.append("    layout: ").append(toIndentedString(layout)).append("\n");
    sb.append("    paint: ").append(toIndentedString(paint)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

