/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.status;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.spi.LoggingSystemProperty;
import org.apache.logging.log4j.util.PropertyEnvironment;

public class StatusLoggerConfiguration {
    private final PropertyEnvironment environment;

    public StatusLoggerConfiguration(PropertyEnvironment environment) {
        this.environment = environment;
    }

    public int getMaxEntries() {
        return this.environment.getIntegerProperty(LoggingSystemProperty.STATUS_MAX_ENTRIES, 200);
    }

    public Level getDefaultLevel() {
        return Level.toLevel(this.environment.getStringProperty(LoggingSystemProperty.STATUS_DEFAULT_LISTENER_LEVEL), Level.WARN);
    }

    public boolean isDebugEnabled() {
        return this.environment.getBooleanProperty(LoggingSystemProperty.STATUS_LOGGER_DEBUG, false, true);
    }

    public DateFormat getDateTimeFormat() {
        String format = this.environment.getStringProperty(LoggingSystemProperty.STATUS_DATE_FORMAT);
        if (format != null) {
            try {
                return new SimpleDateFormat(format);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }
}

