/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AbstractHttpResponseDecoder;
import com.linecorp.armeria.client.GoAwayReceivedException;
import com.linecorp.armeria.client.Http2ClientKeepAliveHandler;
import com.linecorp.armeria.client.HttpClientFactory;
import com.linecorp.armeria.client.HttpResponseWrapper;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.ClosedStreamException;
import com.linecorp.armeria.internal.client.ClosedStreamExceptionUtil;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.Http2GoAwayHandler;
import com.linecorp.armeria.internal.common.InboundTrafficController;
import com.linecorp.armeria.internal.common.KeepAliveHandler;
import com.linecorp.armeria.internal.common.NoopKeepAliveHandler;
import com.linecorp.armeria.internal.shaded.guava.math.LongMath;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Http2ResponseDecoder
extends AbstractHttpResponseDecoder
implements Http2Connection.Listener,
Http2FrameListener {
    private static final Logger logger = LoggerFactory.getLogger(Http2ResponseDecoder.class);
    private final Http2Connection conn;
    private final Http2ConnectionEncoder encoder;
    private final Http2GoAwayHandler goAwayHandler;
    private final KeepAliveHandler keepAliveHandler;

    Http2ResponseDecoder(Channel channel, Http2ConnectionEncoder encoder, HttpClientFactory clientFactory, KeepAliveHandler keepAliveHandler) {
        super(channel, InboundTrafficController.ofHttp2(channel, clientFactory.http2InitialConnectionWindowSize()));
        this.conn = encoder.connection();
        this.encoder = encoder;
        assert (keepAliveHandler instanceof Http2ClientKeepAliveHandler || keepAliveHandler instanceof NoopKeepAliveHandler);
        this.keepAliveHandler = keepAliveHandler;
        this.goAwayHandler = new Http2GoAwayHandler();
    }

    @Override
    void onResponseAdded(int id, EventLoop eventLoop, HttpResponseWrapper resWrapper) {
        resWrapper.whenComplete().handle((unused, cause) -> {
            if (eventLoop.inEventLoop()) {
                this.onWrapperCompleted(resWrapper, id, (Throwable)cause);
            } else {
                eventLoop.execute(() -> this.onWrapperCompleted(resWrapper, id, (Throwable)cause));
            }
            return null;
        });
    }

    private void onWrapperCompleted(HttpResponseWrapper resWrapper, int id, @Nullable Throwable cause) {
        resWrapper.onSubscriptionCancelled(cause);
        if (cause != null) {
            ChannelHandlerContext ctx;
            int streamId = Http2ResponseDecoder.idToStreamId(id);
            int lastStreamId = this.conn.local().lastStreamKnownByPeer();
            if ((lastStreamId < 0 || streamId <= lastStreamId) && (ctx = this.channel().pipeline().lastContext()) != null) {
                this.encoder.writeRstStream(ctx, streamId, Http2Error.CANCEL.code(), ctx.newPromise());
                ctx.flush();
            }
        }
    }

    Http2GoAwayHandler goAwayHandler() {
        return this.goAwayHandler;
    }

    public void onStreamAdded(Http2Stream stream) {
    }

    public void onStreamActive(Http2Stream stream) {
    }

    public void onStreamHalfClosed(Http2Stream stream) {
    }

    public void onStreamClosed(Http2Stream stream) {
        this.goAwayHandler.onStreamClosed(this.channel(), stream);
        HttpResponseWrapper res = this.removeResponse(Http2ResponseDecoder.streamIdToId(stream.id()));
        if (res == null) {
            return;
        }
        if (res.isOpen()) {
            if (!this.goAwayHandler.receivedGoAway()) {
                res.close(ClosedStreamExceptionUtil.newClosedStreamException(this.channel()));
                return;
            }
            int lastStreamId = this.conn.local().lastStreamKnownByPeer();
            if (stream.id() > lastStreamId) {
                res.close(UnprocessedRequestException.of(GoAwayReceivedException.get()));
            } else {
                res.close(ClosedStreamExceptionUtil.newClosedStreamException(this.channel()));
            }
        }
        if (this.shouldSendGoAway()) {
            this.channel().close();
        }
    }

    public void onStreamRemoved(Http2Stream stream) {
    }

    public void onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
        this.session().deactivate();
        this.goAwayHandler.onGoAwaySent(this.channel(), lastStreamId, errorCode, debugData);
    }

    public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
        this.session().deactivate();
        this.goAwayHandler.onGoAwayReceived(this.channel(), lastStreamId, errorCode, debugData);
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
        if (settings.isEmpty()) {
            logger.trace("{} HTTP/2 settings: <empty>", (Object)ctx.channel());
        } else {
            logger.debug("{} HTTP/2 settings: {}", (Object)ctx.channel(), (Object)settings);
        }
        ctx.fireChannelRead((Object)settings);
    }

    public void onSettingsAckRead(ChannelHandlerContext ctx) {
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        boolean written;
        this.keepAliveChannelRead();
        HttpResponseWrapper res = this.getResponse(Http2ResponseDecoder.streamIdToId(streamId));
        if (res == null || !res.isOpen()) {
            if (this.conn.streamMayHaveExisted(streamId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} Received a late HEADERS frame for a closed stream: {}", (Object)ctx.channel(), (Object)streamId);
                }
                return;
            }
            throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"received a HEADERS frame for an unknown stream: %d", (Object[])new Object[]{streamId});
        }
        HttpHeaders converted = ArmeriaHttpUtil.toArmeria(headers, false, endOfStream);
        if (converted instanceof ResponseHeaders) {
            res.startResponse();
            ResponseHeaders responseHeaders = (ResponseHeaders)converted;
            written = responseHeaders.status().codeClass() == HttpStatusClass.INFORMATIONAL ? res.tryWrite(converted) : res.tryWriteResponseHeaders(responseHeaders);
        } else {
            written = res.tryWriteTrailers(converted);
        }
        if (!written) {
            throw Http2Exception.connectionError((Http2Error)Http2Error.INTERNAL_ERROR, (Throwable)ClosedStreamExceptionUtil.newClosedStreamException(ctx), (String)"failed to consume a HEADERS frame", (Object[])new Object[0]);
        }
        if (endOfStream) {
            res.close();
        }
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        this.keepAliveChannelRead();
        int dataLength = data.readableBytes();
        HttpResponseWrapper res = this.getResponse(Http2ResponseDecoder.streamIdToId(streamId));
        if (res == null || !res.isOpen()) {
            if (this.conn.streamMayHaveExisted(streamId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} Received a late DATA frame for a closed stream: {}", (Object)ctx.channel(), (Object)streamId);
                }
                return dataLength + padding;
            }
            throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"received a DATA frame for an unknown stream: %d", (Object[])new Object[]{streamId});
        }
        long maxContentLength = res.maxContentLength();
        long writtenBytes = res.writtenBytes();
        if (maxContentLength > 0L && writtenBytes > maxContentLength - (long)dataLength) {
            long transferred = LongMath.saturatedAdd(writtenBytes, dataLength);
            res.close(Http2ResponseDecoder.contentTooLargeException(res, transferred));
            throw Http2Exception.connectionError((Http2Error)Http2Error.INTERNAL_ERROR, (String)"content too large: transferred(%d + %d) > limit(%d) (stream: %d)", (Object[])new Object[]{writtenBytes, dataLength, maxContentLength, streamId});
        }
        if (!res.tryWriteData(HttpData.wrap(data.retain()).withEndOfStream(endOfStream))) {
            throw Http2Exception.connectionError((Http2Error)Http2Error.INTERNAL_ERROR, (Throwable)ClosedStreamExceptionUtil.newClosedSessionException(ctx), (String)"failed to consume a DATA frame", (Object[])new Object[0]);
        }
        if (endOfStream) {
            res.close();
        }
        return dataLength + padding;
    }

    private boolean shouldSendGoAway() {
        return this.needsToDisconnectNow() && !this.goAwayHandler.sentGoAway() && !this.goAwayHandler.receivedGoAway();
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
        this.keepAliveChannelRead();
        HttpResponseWrapper res = this.getResponse(Http2ResponseDecoder.streamIdToId(streamId));
        if (res == null || !res.isOpen()) {
            if (this.conn.streamMayHaveExisted(streamId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} Received a late RST_STREAM frame for a closed stream: {}", (Object)ctx.channel(), (Object)streamId);
                }
            } else {
                throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"received a RST_STREAM frame for an unknown stream: %d", (Object[])new Object[]{streamId});
            }
            return;
        }
        Http2Error http2Error = Http2Error.valueOf((long)errorCode);
        ClosedStreamException cause = new ClosedStreamException("received a RST_STREAM frame: " + http2Error);
        if (http2Error == Http2Error.REFUSED_STREAM) {
            res.close(UnprocessedRequestException.of(cause));
        } else {
            res.close(cause);
        }
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
    }

    public void onPingRead(ChannelHandlerContext ctx, long data) {
        this.keepAliveHandler.onPing();
    }

    public void onPingAckRead(ChannelHandlerContext ctx, long data) {
        if (this.keepAliveHandler.isHttp2()) {
            this.keepAliveHandler.onPingAck(data);
        }
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
    }

    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
    }

    @Override
    public KeepAliveHandler keepAliveHandler() {
        return this.keepAliveHandler;
    }

    private void keepAliveChannelRead() {
        this.keepAliveHandler.onReadOrWrite();
    }

    private static int streamIdToId(int streamId) {
        return streamId - 1 >>> 1;
    }

    private static int idToStreamId(int id) {
        return (id << 1) + 1;
    }
}

