/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ConnectionPoolListener;
import com.linecorp.armeria.client.ConnectionPoolMetrics;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.util.AttributeMap;
import java.net.InetSocketAddress;
import java.util.Objects;

final class MetricCollectingConnectionPoolListener
implements ConnectionPoolListener {
    private final ConnectionPoolMetrics connectionPoolMetrics;

    MetricCollectingConnectionPoolListener(MeterRegistry registry, MeterIdPrefix idPrefix) {
        Objects.requireNonNull(registry, "registry");
        Objects.requireNonNull(idPrefix, "idPrefix");
        this.connectionPoolMetrics = new ConnectionPoolMetrics(registry, idPrefix);
    }

    @Override
    public void connectionOpen(SessionProtocol protocol, InetSocketAddress remoteAddr, InetSocketAddress localAddr, AttributeMap attrs) throws Exception {
        this.connectionPoolMetrics.increaseConnOpened(protocol, remoteAddr, localAddr);
    }

    @Override
    public void connectionClosed(SessionProtocol protocol, InetSocketAddress remoteAddr, InetSocketAddress localAddr, AttributeMap attrs) throws Exception {
        this.connectionPoolMetrics.increaseConnClosed(protocol, remoteAddr, localAddr);
    }
}

