/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.FutureResponseAs;
import com.linecorp.armeria.client.ResponseAs;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.util.Exceptions;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

final class ResponseAsUtil {
    static final ResponseAs<HttpResponse, AggregatedHttpResponse> BLOCKING = new ResponseAs<HttpResponse, AggregatedHttpResponse>(){

        @Override
        public AggregatedHttpResponse as(HttpResponse response) {
            Objects.requireNonNull(response, "response");
            try {
                return response.aggregate().join();
            }
            catch (Exception ex) {
                return (AggregatedHttpResponse)Exceptions.throwUnsafely(Exceptions.peel(ex));
            }
        }

        @Override
        public boolean requiresAggregation() {
            return true;
        }
    };

    static <T> FutureResponseAs<T> aggregateAndConvert(final ResponseAs<AggregatedHttpResponse, T> responseAs) {
        Objects.requireNonNull(responseAs, "responseAs");
        return new FutureResponseAs<T>(){

            @Override
            public CompletableFuture<T> as(HttpResponse response) {
                Objects.requireNonNull(response, "response");
                return response.aggregate().thenApply(responseAs::as);
            }

            @Override
            public boolean requiresAggregation() {
                return true;
            }
        };
    }

    private ResponseAsUtil() {
    }
}

