/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.circuitbreaker;

import com.linecorp.armeria.client.circuitbreaker.CircuitState;
import com.linecorp.armeria.client.circuitbreaker.EventCount;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.internal.shaded.guava.util.concurrent.AtomicDouble;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

final class CircuitBreakerMetrics {
    private final AtomicReference<EventCount> latestEventCount = new AtomicReference<EventCount>(EventCount.ZERO);
    private final AtomicDouble state = new AtomicDouble(1.0);
    private final Counter transitionsToClosed;
    private final Counter transitionsToOpen;
    private final Counter transitionsToHalfOpen;
    private final Counter transitionsToForcedOpen;
    private final Counter rejectedRequests;

    CircuitBreakerMetrics(MeterRegistry parent, MeterIdPrefix idPrefix) {
        Objects.requireNonNull(parent, "parent");
        Objects.requireNonNull(idPrefix, "idPrefix");
        parent.gauge(idPrefix.name("state"), idPrefix.tags(), (Object)this.state, AtomicDouble::get);
        String requests = idPrefix.name("requests");
        parent.gauge(requests, idPrefix.tags("result", "success"), this.latestEventCount, lec -> ((EventCount)lec.get()).success());
        parent.gauge(requests, idPrefix.tags("result", "failure"), this.latestEventCount, lec -> ((EventCount)lec.get()).failure());
        String transitions = idPrefix.name("transitions");
        this.transitionsToClosed = parent.counter(transitions, idPrefix.tags("state", CircuitState.CLOSED.name()));
        this.transitionsToOpen = parent.counter(transitions, idPrefix.tags("state", CircuitState.OPEN.name()));
        this.transitionsToHalfOpen = parent.counter(transitions, idPrefix.tags("state", CircuitState.HALF_OPEN.name()));
        this.transitionsToForcedOpen = parent.counter(transitions, idPrefix.tags("state", CircuitState.FORCED_OPEN.name()));
        this.rejectedRequests = parent.counter(idPrefix.name("rejected.requests"), idPrefix.tags());
    }

    void onStateChanged(CircuitState state) {
        switch (state) {
            case CLOSED: {
                this.state.set(1.0);
                this.transitionsToClosed.increment();
                break;
            }
            case OPEN: {
                this.state.set(0.0);
                this.transitionsToOpen.increment();
                break;
            }
            case HALF_OPEN: {
                this.state.set(0.5);
                this.transitionsToHalfOpen.increment();
                break;
            }
            case FORCED_OPEN: {
                this.state.set(0.0);
                this.transitionsToForcedOpen.increment();
                break;
            }
            default: {
                throw new Error("unknown circuit state: " + (Object)((Object)state));
            }
        }
    }

    void onCountUpdated(EventCount count) {
        this.latestEventCount.set(count);
    }

    void onRequestRejected() {
        this.rejectedRequests.increment();
    }
}

