/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.AbstractContextAwareExecutor;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;

final class PropagatingContextAwareExecutor
extends AbstractContextAwareExecutor<Executor> {
    static PropagatingContextAwareExecutor of(Executor executor) {
        Objects.requireNonNull(executor, "executor");
        if (executor instanceof PropagatingContextAwareExecutor) {
            return (PropagatingContextAwareExecutor)executor;
        }
        return new PropagatingContextAwareExecutor(executor);
    }

    private PropagatingContextAwareExecutor(Executor executor) {
        super(executor);
    }

    @Override
    RequestContext contextOrNull() {
        return RequestContext.mapCurrent(Function.identity(), AbstractContextAwareExecutor.LogRequestContextWarningOnce.INSTANCE);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("executor", this.withoutContext()).toString();
    }
}

