/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.HeadersSanitizer;
import java.util.Objects;
import java.util.function.BiFunction;

abstract class AbstractLogFormatterBuilder<T> {
    @Nullable
    private HeadersSanitizer<T> requestHeadersSanitizer;
    @Nullable
    private HeadersSanitizer<T> responseHeadersSanitizer;
    @Nullable
    private HeadersSanitizer<T> requestTrailersSanitizer;
    @Nullable
    private HeadersSanitizer<T> responseTrailersSanitizer;
    @Nullable
    private BiFunction<? super RequestContext, Object, ? extends T> requestContentSanitizer;
    @Nullable
    private BiFunction<? super RequestContext, Object, ? extends T> responseContentSanitizer;

    AbstractLogFormatterBuilder() {
    }

    public AbstractLogFormatterBuilder<T> requestHeadersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends T> requestHeadersSanitizer) {
        Objects.requireNonNull(requestHeadersSanitizer, "requestHeadersSanitizer");
        this.requestHeadersSanitizer = requestHeadersSanitizer::apply;
        return this;
    }

    @Nullable
    final HeadersSanitizer<T> requestHeadersSanitizer() {
        return this.requestHeadersSanitizer;
    }

    public AbstractLogFormatterBuilder<T> responseHeadersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends T> responseHeadersSanitizer) {
        Objects.requireNonNull(responseHeadersSanitizer, "responseHeadersSanitizer");
        this.responseHeadersSanitizer = responseHeadersSanitizer::apply;
        return this;
    }

    @Nullable
    final HeadersSanitizer<T> responseHeadersSanitizer() {
        return this.responseHeadersSanitizer;
    }

    public AbstractLogFormatterBuilder<T> requestTrailersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends T> requestTrailersSanitizer) {
        Objects.requireNonNull(requestTrailersSanitizer, "requestTrailersSanitizer");
        this.requestTrailersSanitizer = requestTrailersSanitizer::apply;
        return this;
    }

    @Nullable
    final HeadersSanitizer<T> requestTrailersSanitizer() {
        return this.requestTrailersSanitizer;
    }

    public AbstractLogFormatterBuilder<T> responseTrailersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends T> responseTrailersSanitizer) {
        Objects.requireNonNull(responseTrailersSanitizer, "responseTrailersSanitizer");
        this.responseTrailersSanitizer = responseTrailersSanitizer::apply;
        return this;
    }

    @Nullable
    final HeadersSanitizer<T> responseTrailersSanitizer() {
        return this.responseTrailersSanitizer;
    }

    public AbstractLogFormatterBuilder<T> headersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends T> headersSanitizer) {
        Objects.requireNonNull(headersSanitizer, "headersSanitizer");
        this.requestHeadersSanitizer(headersSanitizer);
        this.requestTrailersSanitizer(headersSanitizer);
        this.responseHeadersSanitizer(headersSanitizer);
        this.responseTrailersSanitizer(headersSanitizer);
        return this;
    }

    public AbstractLogFormatterBuilder<T> requestContentSanitizer(BiFunction<? super RequestContext, Object, ? extends T> requestContentSanitizer) {
        this.requestContentSanitizer = Objects.requireNonNull(requestContentSanitizer, "requestContentSanitizer");
        return this;
    }

    @Nullable
    final BiFunction<? super RequestContext, Object, ? extends T> requestContentSanitizer() {
        return this.requestContentSanitizer;
    }

    public AbstractLogFormatterBuilder<T> responseContentSanitizer(BiFunction<? super RequestContext, Object, ? extends T> responseContentSanitizer) {
        this.responseContentSanitizer = Objects.requireNonNull(responseContentSanitizer, "responseContentSanitizer");
        return this;
    }

    @Nullable
    final BiFunction<? super RequestContext, Object, ? extends T> responseContentSanitizer() {
        return this.responseContentSanitizer;
    }

    public AbstractLogFormatterBuilder<T> contentSanitizer(BiFunction<? super RequestContext, Object, ? extends T> contentSanitizer) {
        Objects.requireNonNull(contentSanitizer, "contentSanitizer");
        this.requestContentSanitizer(contentSanitizer);
        this.responseContentSanitizer(contentSanitizer);
        return this;
    }
}

