/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.common.stream.NoopSubscriber;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.internal.common.stream.InternalStreamMessageUtil;
import com.linecorp.armeria.internal.common.stream.NoopSubscription;
import com.linecorp.armeria.internal.common.stream.SubscriptionArbiter;
import io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class ConcatPublisherStreamMessage<T>
implements StreamMessage<T> {
    private static final AtomicReferenceFieldUpdater<ConcatPublisherStreamMessage, OuterSubscriber> outerSubscriberUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcatPublisherStreamMessage.class, OuterSubscriber.class, "outerSubscriber");
    private final StreamMessage<? extends Publisher<? extends T>> sources;
    @Nullable
    private volatile OuterSubscriber<T> outerSubscriber;

    ConcatPublisherStreamMessage(StreamMessage<? extends Publisher<? extends T>> sources) {
        this.sources = sources;
    }

    @Override
    public boolean isOpen() {
        return this.sources.isOpen();
    }

    @Override
    public boolean isEmpty() {
        return this.sources.isEmpty();
    }

    @Override
    public long demand() {
        OuterSubscriber<T> outerSubscriber = this.outerSubscriber;
        if (outerSubscriber == null) {
            return 0L;
        }
        StreamMessage currentPublisher = ((OuterSubscriber)outerSubscriber).currentStreamMessage;
        if (currentPublisher == null) {
            return 0L;
        }
        return currentPublisher.demand();
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        return this.sources.whenComplete();
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(options, "options");
        InnerSubscriber<? super T> innerSubscriber = new InnerSubscriber<T>(subscriber, options, executor, this);
        OuterSubscriber<? super T> outerSubscriber = new OuterSubscriber<T>(innerSubscriber, executor);
        if (outerSubscriberUpdater.compareAndSet(this, null, outerSubscriber)) {
            subscriber.onSubscribe(innerSubscriber);
            this.sources.subscribe(outerSubscriber, executor, options);
        } else {
            subscriber.onSubscribe((Subscription)NoopSubscription.get());
            subscriber.onError((Throwable)new IllegalStateException("subscribed by other subscriber already"));
        }
    }

    @Override
    public void abort() {
        this.abort(AbortedStreamException.get());
    }

    @Override
    public void abort(Throwable cause) {
        this.sources.abort(cause);
        OuterSubscriber<T> outerSubscriber = this.outerSubscriber;
        if (outerSubscriber != null) {
            ((OuterSubscriber)outerSubscriber).abort(cause);
        }
    }

    private static final class OuterSubscriber<T>
    implements Subscriber<Publisher<? extends T>> {
        private final InnerSubscriber<T> innerSubscriber;
        private final EventExecutor executor;
        private boolean completed;
        private boolean inInnerOnSubscribe;
        @Nullable
        private volatile StreamMessage<? extends T> currentStreamMessage;
        @Nullable
        private volatile Subscription upstream;

        OuterSubscriber(InnerSubscriber<T> innerSubscriber, EventExecutor executor) {
            this.innerSubscriber = innerSubscriber;
            this.executor = executor;
            innerSubscriber.setOuterSubscriber(this);
        }

        public void onSubscribe(Subscription subscription) {
            Objects.requireNonNull(subscription, "subscription");
            if (this.upstream == null) {
                this.upstream = subscription;
                subscription.request(1L);
            } else {
                subscription.cancel();
            }
        }

        public void onNext(Publisher<? extends T> publisher) {
            Objects.requireNonNull(publisher, "publisher");
            StreamMessage<T> streamMessage = StreamMessage.of(publisher);
            this.currentStreamMessage = streamMessage;
            this.inInnerOnSubscribe = true;
            streamMessage.subscribe(this.innerSubscriber, this.executor, ((InnerSubscriber)this.innerSubscriber).options);
        }

        public void onError(Throwable cause) {
            Objects.requireNonNull(cause, "cause");
            if (this.completed) {
                return;
            }
            this.completed = true;
            this.innerSubscriber.onError(cause);
            this.abort(cause);
        }

        private void abort(Throwable cause) {
            StreamMessage<T> currentStreamMessage = this.currentStreamMessage;
            if (currentStreamMessage != null) {
                currentStreamMessage.abort(cause);
            }
        }

        public void onComplete() {
            if (this.completed) {
                return;
            }
            this.completed = true;
            if (!this.inInnerOnSubscribe && ((InnerSubscriber)this.innerSubscriber).currentPublisherCompleted) {
                this.innerSubscriber.onComplete();
            }
        }

        void nextSource() {
            this.upstream.request(1L);
        }
    }

    private static final class InnerSubscriber<T>
    extends SubscriptionArbiter
    implements Subscriber<T> {
        private static final AtomicIntegerFieldUpdater<InnerSubscriber> cancelledUpdater = AtomicIntegerFieldUpdater.newUpdater(InnerSubscriber.class, "cancelled");
        private Subscriber<? super T> downstream;
        private final SubscriptionOption[] options;
        private final ConcatPublisherStreamMessage<T> publisher;
        @Nullable
        private OuterSubscriber<T> outerSubscriber;
        private volatile boolean currentPublisherCompleted = true;
        private volatile int cancelled;
        private boolean error;

        InnerSubscriber(Subscriber<? super T> downstream, SubscriptionOption[] options, EventExecutor executor, ConcatPublisherStreamMessage<T> publisher) {
            super(executor);
            this.downstream = downstream;
            this.options = options;
            this.publisher = publisher;
        }

        void setOuterSubscriber(OuterSubscriber<T> outerSubscriber) {
            this.outerSubscriber = outerSubscriber;
        }

        public void onSubscribe(Subscription subscription) {
            Objects.requireNonNull(subscription, "subscription");
            if (this.isCancelled()) {
                subscription.cancel();
                return;
            }
            this.currentPublisherCompleted = false;
            this.setUpstreamSubscription(subscription);
            ((OuterSubscriber)this.outerSubscriber).inInnerOnSubscribe = false;
        }

        public void onNext(T item) {
            Objects.requireNonNull(item, "item");
            if (this.isCancelled()) {
                return;
            }
            this.downstream.onNext(item);
            this.produced(1L);
        }

        public void onError(Throwable cause) {
            Objects.requireNonNull(cause, "cause");
            if (this.isCancelled()) {
                return;
            }
            if (this.error) {
                return;
            }
            this.error = true;
            this.downstream.onError(cause);
            this.publisher.abort(cause);
        }

        public void onComplete() {
            if (this.isCancelled()) {
                return;
            }
            this.currentPublisherCompleted = true;
            if (((OuterSubscriber)this.outerSubscriber).completed) {
                this.downstream.onComplete();
            } else {
                this.outerSubscriber.nextSource();
            }
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.downstream.onError((Throwable)new IllegalArgumentException("Rule \u00a73.9 violated: non-positive requests are forbidden"));
                return;
            }
            if (this.isCancelled()) {
                return;
            }
            super.request(n);
        }

        @Override
        public void cancel() {
            if (cancelledUpdater.compareAndSet(this, 0, 1)) {
                Subscription upstream;
                if (this.outerSubscriber != null && (upstream = ((OuterSubscriber)this.outerSubscriber).upstream) != null) {
                    upstream.cancel();
                }
                super.cancel();
                CancelledSubscriptionException cause = CancelledSubscriptionException.get();
                this.publisher.abort(cause);
                if (InternalStreamMessageUtil.containsNotifyCancellation(this.options) && !this.currentPublisherCompleted && !this.error) {
                    this.downstream.onError((Throwable)cause);
                }
                this.downstream = NoopSubscriber.get();
            }
        }

        private boolean isCancelled() {
            return this.cancelled != 0;
        }
    }
}

