/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.AttributesGetters;
import com.linecorp.armeria.common.ConcurrentAttributes;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.RequestTarget;
import com.linecorp.armeria.common.RequestTargetForm;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.RequestContextExtension;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;

public abstract class NonWrappingRequestContext
implements RequestContextExtension {
    private static final AtomicReferenceFieldUpdater<NonWrappingRequestContext, Supplier> contextHookUpdater = AtomicReferenceFieldUpdater.newUpdater(NonWrappingRequestContext.class, Supplier.class, "contextHook");
    private final MeterRegistry meterRegistry;
    private final ConcurrentAttributes attrs;
    private SessionProtocol sessionProtocol;
    private final RequestId id;
    private final HttpMethod method;
    private RequestTarget reqTarget;
    private final ExchangeType exchangeType;
    private long requestAutoAbortDelayMillis;
    @Nullable
    private String decodedPath;
    private final Request originalRequest;
    @Nullable
    private volatile HttpRequest req;
    @Nullable
    private volatile RpcRequest rpcReq;
    private volatile Supplier<AutoCloseable> contextHook;

    protected NonWrappingRequestContext(MeterRegistry meterRegistry, SessionProtocol sessionProtocol, RequestId id, HttpMethod method, RequestTarget reqTarget, ExchangeType exchangeType, long requestAutoAbortDelayMillis, @Nullable HttpRequest req, @Nullable RpcRequest rpcReq, @Nullable AttributesGetters rootAttributeMap, Supplier<? extends AutoCloseable> contextHook) {
        assert (req != null || rpcReq != null);
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
        this.attrs = rootAttributeMap == null ? ConcurrentAttributes.of() : ConcurrentAttributes.fromParent(rootAttributeMap);
        this.sessionProtocol = Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        this.id = Objects.requireNonNull(id, "id");
        this.method = Objects.requireNonNull(method, "method");
        this.reqTarget = Objects.requireNonNull(reqTarget, "reqTarget");
        this.exchangeType = Objects.requireNonNull(exchangeType, "exchangeType");
        this.requestAutoAbortDelayMillis = requestAutoAbortDelayMillis;
        this.originalRequest = MoreObjects.firstNonNull(req, rpcReq);
        this.req = req;
        this.rpcReq = rpcReq;
        this.contextHook = contextHook;
    }

    @Override
    public final HttpRequest request() {
        return this.req;
    }

    @Override
    public final RpcRequest rpcRequest() {
        return this.rpcReq;
    }

    @Override
    public final void updateRequest(HttpRequest req) {
        Objects.requireNonNull(req, "req");
        RequestHeaders headers = req.headers();
        RequestTarget reqTarget = this.validateHeaders(headers);
        if (reqTarget == null) {
            throw new IllegalArgumentException("invalid path: " + headers.path());
        }
        if (reqTarget.form() == RequestTargetForm.ABSOLUTE) {
            throw new IllegalArgumentException("invalid path: " + headers.path() + " (must not contain scheme or authority)");
        }
        this.req = req;
        this.reqTarget = reqTarget;
        this.decodedPath = null;
    }

    @Override
    public final void updateRpcRequest(RpcRequest rpcReq) {
        Objects.requireNonNull(rpcReq, "rpcReq");
        this.rpcReq = rpcReq;
    }

    @Nullable
    protected abstract RequestTarget validateHeaders(RequestHeaders var1);

    @Override
    public final SessionProtocol sessionProtocol() {
        return this.sessionProtocol;
    }

    @Nullable
    protected abstract Channel channel();

    @Override
    public final RequestId id() {
        return this.id;
    }

    @Override
    public final HttpMethod method() {
        return this.method;
    }

    @Override
    public final String path() {
        return this.reqTarget.path();
    }

    protected final RequestTarget requestTarget() {
        return this.reqTarget;
    }

    @Override
    public final String decodedPath() {
        String decodedPath = this.decodedPath;
        if (decodedPath != null) {
            return decodedPath;
        }
        this.decodedPath = ArmeriaHttpUtil.decodePath(this.path());
        return this.decodedPath;
    }

    @Override
    public final String query() {
        return this.reqTarget.query();
    }

    @Override
    public ExchangeType exchangeType() {
        return this.exchangeType;
    }

    @Override
    public final MeterRegistry meterRegistry() {
        return this.meterRegistry;
    }

    @Override
    public long requestAutoAbortDelayMillis() {
        return this.requestAutoAbortDelayMillis;
    }

    @Override
    public void setRequestAutoAbortDelayMillis(long delayMillis) {
        this.requestAutoAbortDelayMillis = delayMillis;
    }

    @Override
    @Nullable
    public <V> V attr(AttributeKey<V> key) {
        Objects.requireNonNull(key, "key");
        return this.attrs.attr(key);
    }

    @Override
    @Nullable
    public final <V> V ownAttr(AttributeKey<V> key) {
        Objects.requireNonNull(key, "key");
        return this.attrs.ownAttr(key);
    }

    @Override
    public final <V> V setAttr(AttributeKey<V> key, @Nullable V value) {
        Objects.requireNonNull(key, "key");
        return this.attrs.getAndSet(key, value);
    }

    @Override
    public Iterator<Map.Entry<AttributeKey<?>, Object>> attrs() {
        return this.attrs.attrs();
    }

    @Override
    public final Iterator<Map.Entry<AttributeKey<?>, Object>> ownAttrs() {
        return this.attrs.ownAttrs();
    }

    @Override
    @UnstableApi
    public final AttributesGetters attributes() {
        return this.attrs;
    }

    @Override
    public Request originalRequest() {
        return this.originalRequest;
    }

    @Override
    @UnstableApi
    public void hook(Supplier<? extends AutoCloseable> contextHook) {
        Supplier<AutoCloseable> newContextHook;
        Supplier<AutoCloseable> oldContextHook;
        Objects.requireNonNull(contextHook, "contextHook");
        if (contextHook == RequestContextUtil.NOOP_CONTEXT_HOOK) {
            return;
        }
        while (!contextHookUpdater.compareAndSet(this, oldContextHook = this.contextHook, newContextHook = RequestContextUtil.mergeHooks(oldContextHook, contextHook))) {
        }
    }

    @Override
    public Supplier<AutoCloseable> hook() {
        return this.contextHook;
    }
}

