/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.fastutil.longs;

import com.linecorp.armeria.internal.shaded.fastutil.longs.AbstractLongSet;
import com.linecorp.armeria.internal.shaded.fastutil.longs.LongArrays;
import com.linecorp.armeria.internal.shaded.fastutil.longs.LongIterator;
import com.linecorp.armeria.internal.shaded.fastutil.longs.LongSpliterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.LongConsumer;

public class LongArraySet
extends AbstractLongSet
implements Serializable,
Cloneable {
    protected transient long[] a;
    protected int size;

    public LongArraySet(long[] a) {
        this.a = a;
        this.size = a.length;
    }

    public LongArraySet() {
        this.a = LongArrays.EMPTY_ARRAY;
    }

    private int findKey(long o) {
        int i = this.size;
        while (i-- != 0) {
            if (this.a[i] != o) continue;
            return i;
        }
        return -1;
    }

    @Override
    public LongIterator iterator() {
        return new LongIterator(){
            int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < LongArraySet.this.size;
            }

            @Override
            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return LongArraySet.this.a[this.next++];
            }

            @Override
            public void remove() {
                int tail = LongArraySet.this.size-- - this.next--;
                System.arraycopy(LongArraySet.this.a, this.next + 1, LongArraySet.this.a, this.next, tail);
            }
        };
    }

    @Override
    public LongSpliterator spliterator() {
        return new Spliterator();
    }

    @Override
    public boolean contains(long k) {
        return this.findKey(k) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean remove(long k) {
        int pos = this.findKey(k);
        if (pos == -1) {
            return false;
        }
        int tail = this.size - pos - 1;
        for (int i = 0; i < tail; ++i) {
            this.a[pos + i] = this.a[pos + i + 1];
        }
        --this.size;
        return true;
    }

    @Override
    public boolean add(long k) {
        int pos = this.findKey(k);
        if (pos != -1) {
            return false;
        }
        if (this.size == this.a.length) {
            long[] b = new long[this.size == 0 ? 2 : this.size * 2];
            int i = this.size;
            while (i-- != 0) {
                b[i] = this.a[i];
            }
            this.a = b;
        }
        this.a[this.size++] = k;
        return true;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public long[] toLongArray() {
        if (this.size == 0) {
            return LongArrays.EMPTY_ARRAY;
        }
        return Arrays.copyOf(this.a, this.size);
    }

    public LongArraySet clone() {
        LongArraySet c;
        try {
            c = (LongArraySet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.a = (long[])this.a.clone();
        return c;
    }

    private final class Spliterator
    implements LongSpliterator {
        boolean hasSplit = false;
        int pos;
        int max;

        public Spliterator() {
            this(0, longArraySet.size, false);
        }

        private Spliterator(int pos, int max, boolean hasSplit) {
            assert (pos <= max) : "pos " + pos + " must be <= max " + max;
            this.pos = pos;
            this.max = max;
            this.hasSplit = hasSplit;
        }

        private int getWorkingMax() {
            return this.hasSplit ? this.max : LongArraySet.this.size;
        }

        @Override
        public int characteristics() {
            return 16721;
        }

        @Override
        public long estimateSize() {
            return this.getWorkingMax() - this.pos;
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            if (this.pos >= this.getWorkingMax()) {
                return false;
            }
            action.accept(LongArraySet.this.a[this.pos++]);
            return true;
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            int max = this.getWorkingMax();
            while (this.pos < max) {
                action.accept(LongArraySet.this.a[this.pos]);
                ++this.pos;
            }
        }

        @Override
        public LongSpliterator trySplit() {
            int myNewPos;
            int max = this.getWorkingMax();
            int retLen = max - this.pos >> 1;
            if (retLen <= 1) {
                return null;
            }
            this.max = max;
            int retMax = myNewPos = this.pos + retLen;
            int oldPos = this.pos;
            this.pos = myNewPos;
            this.hasSplit = true;
            return new Spliterator(oldPos, retMax, true);
        }
    }
}

