/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.guava.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ClassToInstanceMap;
import com.linecorp.armeria.internal.shaded.guava.collect.CollectSpliterators;
import com.linecorp.armeria.internal.shaded.guava.collect.ForwardingMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ForwardingMapEntry;
import com.linecorp.armeria.internal.shaded.guava.collect.ForwardingSet;
import com.linecorp.armeria.internal.shaded.guava.collect.TransformedIterator;
import com.linecorp.armeria.internal.shaded.guava.primitives.Primitives;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class MutableClassToInstanceMap<B>
extends ForwardingMap<Class<? extends B>, B>
implements ClassToInstanceMap<B>,
Serializable {
    private final Map<Class<? extends @NonNull B>, B> delegate;

    public static <B> MutableClassToInstanceMap<B> create() {
        return new MutableClassToInstanceMap(new HashMap());
    }

    private MutableClassToInstanceMap(Map<Class<? extends @NonNull B>, B> delegate) {
        this.delegate = Preconditions.checkNotNull(delegate);
    }

    @Override
    protected Map<Class<? extends @NonNull B>, B> delegate() {
        return this.delegate;
    }

    private static <B> Map.Entry<Class<? extends @NonNull B>, B> checkedEntry(final Map.Entry<Class<? extends @NonNull B>, B> entry) {
        return new ForwardingMapEntry<Class<? extends B>, B>(){

            @Override
            protected Map.Entry<Class<? extends @NonNull B>, B> delegate() {
                return entry;
            }

            @Override
            public B setValue(B value) {
                MutableClassToInstanceMap.cast((Class)this.getKey(), value);
                return super.setValue(value);
            }
        };
    }

    @Override
    public Set<Map.Entry<Class<? extends @NonNull B>, B>> entrySet() {
        return new ForwardingSet<Map.Entry<Class<? extends B>, B>>(){

            @Override
            protected Set<Map.Entry<Class<? extends @NonNull B>, B>> delegate() {
                return MutableClassToInstanceMap.this.delegate().entrySet();
            }

            @Override
            public Spliterator<Map.Entry<Class<? extends @NonNull B>, B>> spliterator() {
                return CollectSpliterators.map(this.delegate().spliterator(), x$0 -> MutableClassToInstanceMap.checkedEntry(x$0));
            }

            @Override
            public Iterator<Map.Entry<Class<? extends @NonNull B>, B>> iterator() {
                return new TransformedIterator<Map.Entry<Class<? extends B>, B>, Map.Entry<Class<? extends B>, B>>(this, this.delegate().iterator()){

                    @Override
                    Map.Entry<Class<? extends @NonNull B>, B> transform(Map.Entry<Class<? extends @NonNull B>, B> from) {
                        return MutableClassToInstanceMap.checkedEntry(from);
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] result = this.standardToArray();
                return result;
            }

            @Override
            public <T> T[] toArray(T[] array) {
                return this.standardToArray(array);
            }
        };
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public B put(Class<? extends @NonNull B> key, B value) {
        MutableClassToInstanceMap.cast(key, value);
        return super.put(key, value);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void putAll(Map<? extends Class<? extends @NonNull B>, ? extends B> map) {
        LinkedHashMap<Class<@NonNull B>, B> copy = new LinkedHashMap<Class<B>, B>(map);
        for (Map.Entry entry : copy.entrySet()) {
            MutableClassToInstanceMap.cast((Class)entry.getKey(), entry.getValue());
        }
        super.putAll(copy);
    }

    @Override
    @CheckForNull
    public <T extends B> T getInstance(Class<T> type) {
        return MutableClassToInstanceMap.cast(type, this.get(type));
    }

    @CheckForNull
    @CanIgnoreReturnValue
    private static <T> T cast(Class<T> type, @CheckForNull Object value) {
        return Primitives.wrap(type).cast(value);
    }
}

