/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.cors;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.cors.CorsPolicy;
import com.linecorp.armeria.server.cors.CorsServiceBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public final class CorsConfig {
    private final boolean anyOriginSupported;
    private final boolean shortCircuit;
    private final List<CorsPolicy> policies;

    CorsConfig(CorsServiceBuilder builder) {
        this.anyOriginSupported = builder.anyOriginSupported;
        this.shortCircuit = builder.shortCircuit;
        this.policies = ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().add(builder.firstPolicyBuilder.build())).addAll(builder.policies)).build();
    }

    public boolean isAnyOriginSupported() {
        return this.anyOriginSupported;
    }

    public boolean isShortCircuit() {
        return this.shortCircuit;
    }

    public List<CorsPolicy> policies() {
        return this.policies;
    }

    @Nullable
    public CorsPolicy getPolicy(@Nullable String origin, RoutingContext routingContext) {
        Objects.requireNonNull(routingContext, "routingContext");
        if (origin == null) {
            return null;
        }
        if (this.isAnyOriginSupported()) {
            return Iterables.getFirst(this.policies, null);
        }
        String lowerCaseOrigin = Ascii.toLowerCase(origin);
        boolean isNullOrigin = "null".equals(lowerCaseOrigin);
        for (CorsPolicy policy : this.policies) {
            if (isNullOrigin && policy.isNullOriginAllowed() && CorsConfig.isPathMatched(policy, routingContext)) {
                return policy;
            }
            if (isNullOrigin || !policy.origins().contains(lowerCaseOrigin) || !CorsConfig.isPathMatched(policy, routingContext)) continue;
            return policy;
        }
        return null;
    }

    private static boolean isPathMatched(CorsPolicy policy, RoutingContext routingContext) {
        List<Route> routes = policy.routes();
        return routes.isEmpty() || routes.stream().anyMatch(route -> route.apply(routingContext, false).isPresent());
    }

    public String toString() {
        return CorsConfig.toString(this, this.anyOriginSupported, this.shortCircuit, this.policies);
    }

    static String toString(Object obj, boolean anyOriginSupported, boolean shortCircuit, List<CorsPolicy> policies) {
        return MoreObjects.toStringHelper(obj).add("policies", policies).add("shortCircuit", shortCircuit).add("anyOriginSupported", anyOriginSupported).toString();
    }

    static final class ConstantValueSupplier
    implements Supplier<Object> {
        static final ConstantValueSupplier ZERO = new ConstantValueSupplier("0");
        private final Object value;

        ConstantValueSupplier(Object value) {
            this.value = value;
        }

        @Override
        public Object get() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

