/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.geocoder;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.annotation.JacksonResponseConverterFunction;
import com.linecorp.armeria.server.cors.CorsService;
import com.linecorp.armeria.server.docs.DocService;
import com.linecorp.armeria.server.file.FileService;
import com.linecorp.armeria.server.file.HttpFile;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import org.apache.baremaps.server.GeocoderResource;
import org.apache.baremaps.utils.ObjectMapperUtils;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="serve", description={"Start a tile server with caching capabilities."})
public class Serve
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(Serve.class);
    @CommandLine.Option(names={"--index"}, paramLabel="INDEX", description={"The path to the lucene index."}, required=true)
    private Path indexDirectory;
    @CommandLine.Option(names={"--host"}, paramLabel="HOST", description={"The host of the server."})
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, paramLabel="PORT", description={"The port of the server."})
    private int port = 9000;

    @Override
    public Integer call() throws Exception {
        try (FSDirectory directory = MMapDirectory.open((Path)this.indexDirectory);
             SearcherManager searcherManager = new SearcherManager((Directory)directory, new SearcherFactory());){
            ServerBuilder serverBuilder = Server.builder();
            serverBuilder.http(this.port);
            ObjectMapper objectMapper = ObjectMapperUtils.objectMapper();
            JacksonResponseConverterFunction jsonResponseConverter = new JacksonResponseConverterFunction(objectMapper);
            serverBuilder.annotatedService((Object)new GeocoderResource(searcherManager), new Object[]{jsonResponseConverter});
            HttpFile index = HttpFile.of((ClassLoader)ClassLoader.getSystemClassLoader(), (String)"/geocoder/index.html");
            serverBuilder.service("/", index.asService());
            serverBuilder.serviceUnder("/", (HttpService)FileService.of((ClassLoader)ClassLoader.getSystemClassLoader(), (String)"/geocoder"));
            serverBuilder.decorator(CorsService.builderForAnyOrigin().allowRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.OPTIONS, HttpMethod.HEAD}).allowRequestHeaders(new CharSequence[]{HttpHeaderNames.ORIGIN, HttpHeaderNames.CONTENT_TYPE, HttpHeaderNames.ACCEPT, HttpHeaderNames.AUTHORIZATION}).allowCredentials().exposeHeaders(new CharSequence[]{HttpHeaderNames.LOCATION}).newDecorator());
            serverBuilder.serviceUnder("/docs", (HttpService)new DocService());
            serverBuilder.disableServerHeader();
            serverBuilder.disableDateHeader();
            Server server = serverBuilder.build();
            CompletableFuture startFuture = server.start();
            startFuture.join();
            CompletableFuture shutdownFuture = server.closeOnJvmShutdown();
            shutdownFuture.join();
        }
        return 0;
    }
}

