/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.collection;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.baremaps.database.collection.DataCollectionException;
import org.apache.baremaps.database.collection.DataMap;
import org.apache.baremaps.database.memory.Memory;
import org.apache.baremaps.database.type.FixedSizeDataType;

public class MemoryAlignedDataMap<E>
extends DataMap<Long, E> {
    private final FixedSizeDataType<E> dataType;
    private final Memory memory;
    private final int valueShift;
    private final long segmentShift;
    private final long segmentMask;

    public MemoryAlignedDataMap(FixedSizeDataType<E> dataType, Memory memory) {
        if (dataType.size() > memory.segmentSize()) {
            throw new DataCollectionException("The segment size is too small for the data type");
        }
        if ((dataType.size() & -dataType.size()) != dataType.size()) {
            throw new IllegalArgumentException("The data type size must be a fixed power of 2");
        }
        if (memory.segmentSize() % dataType.size() != 0) {
            throw new DataCollectionException("The segment size and data type size must be aligned");
        }
        this.dataType = dataType;
        this.memory = memory;
        this.valueShift = (int)(Math.log(dataType.size()) / Math.log(2.0));
        this.segmentShift = memory.segmentShift();
        this.segmentMask = memory.segmentMask();
    }

    @Override
    public E put(Long key, E value) {
        long position = key << this.valueShift;
        int segmentIndex = (int)(position >>> (int)this.segmentShift);
        int segmentOffset = (int)(position & this.segmentMask);
        ByteBuffer segment = this.memory.segment(segmentIndex);
        Object previous = this.dataType.read(segment, segmentOffset);
        this.dataType.write(segment, segmentOffset, value);
        return (E)previous;
    }

    @Override
    public E get(Object key) {
        long position = (Long)key << this.valueShift;
        int segmentIndex = (int)(position >>> (int)this.segmentShift);
        int segmentOffset = (int)(position & this.segmentMask);
        ByteBuffer segment = this.memory.segment(segmentIndex);
        return (E)this.dataType.read(segment, segmentOffset);
    }

    @Override
    public E remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object keyObject) {
        if (keyObject instanceof Long) {
            Long key = (Long)keyObject;
            return key >= 0L && key < (long)this.size();
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public long sizeAsLong() {
        return this.memory.size() / (long)this.dataType.size();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Iterator<Long> keyIterator() {
        return new Iterator<Long>(){
            private long index = 0L;
            private long size = MemoryAlignedDataMap.this.sizeAsLong();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.index++;
            }
        };
    }

    @Override
    protected Iterator<E> valueIterator() {
        return new Iterator<E>(){
            private long index = 0L;
            private long size = MemoryAlignedDataMap.this.sizeAsLong();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return MemoryAlignedDataMap.this.get(this.index++);
            }
        };
    }

    @Override
    protected Iterator<Map.Entry<Long, E>> entryIterator() {
        return new Iterator<Map.Entry<Long, E>>(){
            private long index = 0L;
            private long size = MemoryAlignedDataMap.this.sizeAsLong();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Map.Entry<Long, E> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                long key = this.index++;
                return Map.entry(key, MemoryAlignedDataMap.this.get(key));
            }
        };
    }
}

