/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.stream;

import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.baremaps.stream.BatchedSpliterator;
import org.apache.baremaps.stream.BufferedSpliterator;
import org.apache.baremaps.stream.PartitionedSpliterator;
import org.apache.baremaps.stream.StreamException;

public class StreamUtils {
    public static <T> Stream<T> stream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    public static <T> Stream<T> batch(Stream<T> stream) {
        return StreamUtils.batch(stream, 1);
    }

    public static <T> Stream<T> batch(Stream<T> stream, int batchSize) {
        return StreamSupport.stream(new BatchedSpliterator(stream.spliterator(), batchSize), true);
    }

    private static <T> Stream<CompletableFuture<T>> buffer(Stream<CompletableFuture<T>> asyncStream, BufferedSpliterator.CompletionOrder completionOrder) {
        return StreamUtils.buffer(asyncStream, completionOrder, Runtime.getRuntime().availableProcessors());
    }

    private static <T> Stream<CompletableFuture<T>> buffer(Stream<CompletableFuture<T>> asyncStream, BufferedSpliterator.CompletionOrder completionOrder, int bufferSize) {
        return StreamSupport.stream(new BufferedSpliterator(asyncStream.spliterator(), bufferSize, completionOrder), asyncStream.isParallel());
    }

    public static <T> Stream<CompletableFuture<T>> bufferInCompletionOrder(Stream<CompletableFuture<T>> asyncStream, int bufferSize) {
        return StreamUtils.buffer(asyncStream, BufferedSpliterator.InCompletionOrder.INSTANCE, bufferSize);
    }

    public static <T> Stream<CompletableFuture<T>> bufferInSourceOrder(Stream<CompletableFuture<T>> asyncStream, int bufferSize) {
        return StreamUtils.buffer(asyncStream, BufferedSpliterator.InSourceOrder.INSTANCE, bufferSize);
    }

    private static <T, U> Stream<U> buffer(Stream<T> stream, Function<T, U> asyncMapper, BufferedSpliterator.CompletionOrder completionOrder, int bufferSize) {
        Stream<CompletableFuture<T>> asyncStream = stream.map(t -> CompletableFuture.supplyAsync(() -> asyncMapper.apply(t)));
        return StreamUtils.buffer(asyncStream, completionOrder, bufferSize).map(f -> {
            try {
                return f.get();
            }
            catch (ExecutionException e) {
                throw new StreamException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new StreamException(e);
            }
        });
    }

    public static <T, U> Stream<U> bufferInCompletionOrder(Stream<T> stream, Function<T, U> asyncMapper, int bufferSize) {
        return StreamUtils.buffer(stream, asyncMapper, BufferedSpliterator.InCompletionOrder.INSTANCE, bufferSize);
    }

    public static <T, U> Stream<U> bufferInSourceOrder(Stream<T> stream, Function<T, U> asyncMapper, int bufferSize) {
        return StreamUtils.buffer(stream, asyncMapper, BufferedSpliterator.InSourceOrder.INSTANCE, bufferSize);
    }

    public static <T> Stream<List<T>> partition(Stream<T> stream, int partitionSize) {
        return StreamSupport.stream(new PartitionedSpliterator(stream.spliterator(), partitionSize), stream.isParallel());
    }
}

