/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore.pmtiles;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.hash.Hashing;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.baremaps.tilestore.pmtiles.Compression;
import org.apache.baremaps.tilestore.pmtiles.Directories;
import org.apache.baremaps.tilestore.pmtiles.Entry;
import org.apache.baremaps.tilestore.pmtiles.Header;
import org.apache.baremaps.tilestore.pmtiles.PMTiles;
import org.apache.baremaps.tilestore.pmtiles.TileType;

public class PMTilesWriter {
    private Compression compression = Compression.Gzip;
    private Path path;
    private Map<String, Object> metadata = new HashMap<String, Object>();
    private List<Entry> entries;
    private Map<Long, Long> tileHashToOffset;
    private Long lastTileHash = null;
    private Path tilePath;
    private boolean clustered = true;
    private int minZoom = 0;
    private int maxZoom = 14;
    private double minLon = -180.0;
    private double minLat = -90.0;
    private double maxLon = 180.0;
    private double maxLat = 90.0;
    private int centerZoom = 3;
    private double centerLat = 0.0;
    private double centerLon = 0.0;

    public PMTilesWriter(Path path) throws IOException {
        this(path, new ArrayList<Entry>(), new HashMap<Long, Long>());
    }

    public PMTilesWriter(Path path, List<Entry> entries, Map<Long, Long> tileHashToOffset) throws IOException {
        this.path = path;
        this.entries = entries;
        this.tileHashToOffset = tileHashToOffset;
        this.tilePath = Files.createTempFile(path.getParent(), "tiles_", ".tmp", new FileAttribute[0]);
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public void setTile(int z, int x, int y, byte[] bytes) throws IOException {
        long tileId = PMTiles.zxyToTileId(z, x, y);
        int tileLength = bytes.length;
        Long tileHash = Hashing.farmHashFingerprint64().hashBytes(bytes).asLong();
        if (this.entries.size() > 0 && tileId < this.entries.get(this.entries.size() - 1).getTileId()) {
            this.clustered = false;
        }
        if (this.clustered && tileHash.equals(this.lastTileHash)) {
            Entry lastEntry = this.entries.get(this.entries.size() - 1);
            lastEntry.setRunLength(lastEntry.getRunLength() + 1L);
        } else if (this.tileHashToOffset.containsKey(tileHash)) {
            Long tileOffset = this.tileHashToOffset.get(tileHash);
            this.entries.add(new Entry(tileId, tileOffset, tileLength, 1L));
        } else {
            long tileOffset = Files.size(this.tilePath);
            this.tileHashToOffset.put(tileHash, tileOffset);
            this.lastTileHash = tileHash;
            try (FileOutputStream output = new FileOutputStream(this.tilePath.toFile(), true);){
                output.write(bytes);
                this.entries.add(new Entry(tileId, tileOffset, tileLength, 1L));
            }
        }
    }

    public void setMinZoom(int minZoom) {
        this.minZoom = minZoom;
    }

    public void setMaxZoom(int maxZoom) {
        this.maxZoom = maxZoom;
    }

    public void setMinLon(double minLon) {
        this.minLon = minLon;
    }

    public void setMinLat(double minLat) {
        this.minLat = minLat;
    }

    public void setMaxLon(double maxLon) {
        this.maxLon = maxLon;
    }

    public void setMaxLat(double maxLat) {
        this.maxLat = maxLat;
    }

    public void setCenterZoom(int centerZoom) {
        this.centerZoom = centerZoom;
    }

    public void setCenterLat(double centerLat) {
        this.centerLat = centerLat;
    }

    public void setCenterLon(double centerLon) {
        this.centerLon = centerLon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        byte[] metadataBytes;
        if (!this.clustered) {
            this.entries.sort(Comparator.comparingLong(Entry::getTileId));
        }
        Directories directories = PMTiles.optimizeDirectories(this.entries, 16247, this.compression);
        try (ByteArrayOutputStream metadataOutput = new ByteArrayOutputStream();){
            try (OutputStream compressedMetadataOutput = this.compression.compress(metadataOutput);){
                new ObjectMapper().writeValue(compressedMetadataOutput, this.metadata);
            }
            metadataBytes = metadataOutput.toByteArray();
        }
        int rootOffset = 127;
        int rootLength = directories.getRoot().length;
        int metadataOffset = rootOffset + rootLength;
        int metadataLength = metadataBytes.length;
        int leavesOffset = metadataOffset + metadataLength;
        int leavesLength = directories.getLeaves().length;
        int tilesOffset = leavesOffset + leavesLength;
        long tilesLength = Files.size(this.tilePath);
        int numTiles = this.entries.size();
        Header header = new Header();
        header.setNumAddressedTiles(numTiles);
        header.setNumTileEntries(numTiles);
        header.setNumTileContents(this.tileHashToOffset.size());
        header.setClustered(true);
        header.setInternalCompression(this.compression);
        header.setTileCompression(this.compression);
        header.setTileType(TileType.mvt);
        header.setRootOffset(rootOffset);
        header.setRootLength(rootLength);
        header.setMetadataOffset(metadataOffset);
        header.setMetadataLength(metadataLength);
        header.setLeavesOffset(leavesOffset);
        header.setLeavesLength(leavesLength);
        header.setTilesOffset(tilesOffset);
        header.setTilesLength(tilesLength);
        header.setMinZoom(this.minZoom);
        header.setMaxZoom(this.maxZoom);
        header.setMinLon(this.minLon);
        header.setMinLat(this.minLat);
        header.setMaxLon(this.maxLon);
        header.setMaxLat(this.maxLat);
        header.setCenterZoom(this.centerZoom);
        header.setCenterLat(this.centerLat);
        header.setCenterLon(this.centerLon);
        try (FileOutputStream output = new FileOutputStream(this.path.toFile());){
            output.write(PMTiles.serializeHeader(header));
            output.write(directories.getRoot());
            output.write(metadataBytes);
            output.write(directories.getLeaves());
            Files.copy(this.tilePath, output);
        }
        finally {
            Files.delete(this.tilePath);
        }
    }
}

