/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.utils;

import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.util.GeometryTransformer;

public class RoundingTransformer
extends GeometryTransformer {
    private int precision;

    public RoundingTransformer(int precision) {
        this.precision = precision;
    }

    protected CoordinateSequence transformCoordinates(CoordinateSequence sequence, Geometry parent) {
        CoordinateSequence rounded = super.transformCoordinates(sequence, parent);
        for (int i = 0; i < rounded.size(); ++i) {
            double roundedX = (double)Math.round(rounded.getOrdinate(i, 0) * Math.pow(10.0, this.precision)) / Math.pow(10.0, this.precision);
            double roundedY = (double)Math.round(rounded.getOrdinate(i, 1) * Math.pow(10.0, this.precision)) / Math.pow(10.0, this.precision);
            rounded.setOrdinate(i, 0, roundedX);
            rounded.setOrdinate(i, 1, roundedY);
        }
        return rounded;
    }
}

