/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.sis.io.wkt.StoredTree;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.factory.FactoryDataException;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.apache.sis.referencing.util.WKTKeywords;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.collection.FrequencySortedSet;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public class WKTDictionary
extends GeodeticAuthorityFactory {
    private volatile Citation authority;
    private final Set<String> authorities;
    private final Set<String> codespaces;
    private final Map<Class<?>, Set<String>> codeCaches;
    protected final WKTFormat parser;
    private final ReadWriteLock lock;
    private final Map<String, Object> definitions = new HashMap<String, Object>();

    public WKTDictionary(Citation authority) {
        this.codeCaches = new HashMap();
        this.codespaces = new FrequencySortedSet(true);
        this.parser = new WKTFormat(null, null);
        this.lock = new ReentrantReadWriteLock();
        this.authorities = authority != null ? null : new FrequencySortedSet(true);
        this.authority = authority;
    }

    private void updateAuthority() {
        this.codeCaches.clear();
        if (this.authorities != null) {
            String name = (String)CollectionsExt.first(this.authorities);
            if (name == null) {
                name = (String)CollectionsExt.first(this.codespaces);
            }
            this.authority = Citations.fromName((String)name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(BufferedReader source) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        this.lock.writeLock().lock();
        try {
            Loader loader = new Loader(source);
            try {
                loader.read();
            }
            catch (IOException e) {
                throw new FactoryException(loader.canNotRead(null, e), (Throwable)e);
            }
            catch (IllegalArgumentException | ParseException e) {
                throw new FactoryDataException(loader.canNotRead(null, e), e);
            }
            finally {
                loader.restore();
                this.updateAuthority();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void addDefinition(StoredTree tree) throws FactoryDataException {
        String title;
        Object[] fullId = new Object[this.authorities == null ? 4 : 3];
        tree.peekIdentifiers(fullId);
        String code = WKTDictionary.trimOrNull(fullId[1]);
        if (code == null) {
            throw new FactoryDataException(this.resources().getString((short)37, tree));
        }
        String codespace = WKTDictionary.trimOrNull(fullId[0]);
        this.definitions.merge(code, tree, (oldValue, newValue) -> new Disambiguation(codespace, WKTDictionary.trimOrNull(fullId[2]), code, oldValue, newValue));
        this.codespaces.add(codespace);
        if (fullId.length >= 4 && (title = WKTDictionary.trimOrNull(fullId[3])) != null) {
            this.authorities.add(title);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefinitions(Stream<String> objects) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"objects", objects);
        Iterator it = objects.iterator();
        ParsePosition pos = new ParsePosition(0);
        this.lock.writeLock().lock();
        try {
            int lineNumber = 1;
            try {
                while (it.hasNext()) {
                    String wkt = (String)it.next();
                    StoredTree tree = this.parser.textToTree(wkt, pos, null);
                    int end = pos.getIndex();
                    if (end < CharSequences.skipTrailingWhitespaces((CharSequence)wkt, (int)0, (int)wkt.length())) {
                        throw new FactoryDataException(this.unexpectedText(lineNumber, wkt, end));
                    }
                    this.addDefinition(tree);
                    pos.setIndex(0);
                    ++lineNumber;
                }
                this.parser.logWarnings(WKTDictionary.class, "addDefinitions");
            }
            catch (IllegalArgumentException | ParseException e) {
                throw new FactoryDataException(this.resources().getString((short)96, lineNumber, e.getLocalizedMessage()));
            }
            finally {
                this.parser.clear();
                this.updateAuthority();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * Loose catch block
     */
    private IdentifiedObject parseAndAdd(String codespace, String version, String code, String wkt, DefaultIdentifier defaultIdentifier) throws FactoryException {
        ArgumentChecks.ensureNonEmpty((String)"code", (CharSequence)code);
        ArgumentChecks.ensureNonEmpty((String)"wkt", (CharSequence)wkt);
        this.lock.writeLock().lock();
        try {
            try {
                this.parser.setDefaultIdentifier(defaultIdentifier);
                Object object = this.parser.parseObject(wkt);
                if (!(object instanceof IdentifiedObject)) {
                    throw new FactoryDataException(this.parser.errors().getString((short)143, (Object)code, IdentifiedObject.class, object.getClass()));
                }
                Disambiguation entry = (Disambiguation)this.definitions.compute(code, (key, oldValue) -> new Disambiguation(codespace, version, code, oldValue, object));
                this.codespaces.add(entry.codespace);
                IdentifiedObject identifiedObject = (IdentifiedObject)object;
                return identifiedObject;
            }
            catch (IllegalArgumentException | ParseException e) {
                throw new FactoryDataException(e.getLocalizedMessage());
            }
            finally {
                this.parser.setDefaultIdentifier(null);
                this.parser.clear();
                this.updateAuthority();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected String fetchDefinition(DefaultIdentifier identifier) throws FactoryException {
        return null;
    }

    private String unexpectedText(int lineNumber, String wkt, int end) {
        return this.resources().getString((short)98, lineNumber, CharSequences.token((CharSequence)wkt, (int)end));
    }

    private Resources resources() {
        return Resources.forLocale(this.parser.getErrorLocale());
    }

    private static String trimOrNull(Object value) {
        return value != null ? Strings.trimOrNull((String)value.toString()) : null;
    }

    final void forEachValue(Consumer<Object> addTo) {
        for (Object value : this.definitions.values()) {
            if (value instanceof Disambiguation) {
                Disambiguation choices = (Disambiguation)value;
                do {
                    addTo.accept(choices.value);
                } while ((choices = choices.previous) != null);
                continue;
            }
            addTo.accept(value);
        }
    }

    @Override
    public Citation getAuthority() {
        return this.authority;
    }

    @Override
    public Set<String> getCodeSpaces() {
        this.lock.readLock().lock();
        try {
            Set set = CollectionsExt.copyPreserveOrder(this.codespaces);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) throws FactoryException {
        Set codes;
        ArgumentChecks.ensureNonNull((String)"type", type);
        if (!type.isInterface()) {
            type = ReferencingUtilities.getInterface(IdentifiedObject.class, type);
        }
        this.lock.readLock().lock();
        try {
            codes = this.codeCaches.get(type);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (codes == null) {
            String[] keywords = WKTKeywords.forType(type);
            Class<? extends IdentifiedObject> baseType = type;
            Predicate<Object> filter = element -> {
                if (element instanceof StoredTree) {
                    return keywords == null || ArraysExt.containsIgnoreCase((String[])keywords, (String)((StoredTree)element).keyword());
                }
                return baseType.isInstance(element);
            };
            this.lock.writeLock().lock();
            try {
                codes = this.codeCaches.get(type);
                if (codes == null) {
                    codes = new HashSet<String>();
                    for (Map.Entry<String, Object> entry : this.definitions.entrySet()) {
                        String code = entry.getKey();
                        Object value = entry.getValue();
                        if (value instanceof Disambiguation) {
                            Disambiguation.list((Disambiguation)value, code, filter, codes);
                            continue;
                        }
                        if (!filter.test(value)) continue;
                        codes.add(code);
                    }
                    for (Set set : this.codeCaches.values()) {
                        if (!codes.equals(set)) continue;
                        codes = set;
                        break;
                    }
                    codes = Set.copyOf(codes);
                    this.codeCaches.put(type, codes);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return codes;
    }

    @Override
    public InternationalString getDescriptionText(String code) throws FactoryException {
        String text;
        Object value = this.getOrCreate(code, false);
        if (value instanceof IdentifiedObject) {
            text = ((IdentifiedObject)value).getName().getCode();
        } else {
            text = String.valueOf(value);
            if (!(value instanceof StoredTree)) {
                throw new FactoryException(text);
            }
        }
        return new SimpleInternationalString(text);
    }

    @Override
    public IdentifiedObject createObject(String code) throws FactoryException {
        Object value = this.getOrCreate(code, true);
        if (value instanceof IdentifiedObject) {
            return (IdentifiedObject)value;
        }
        throw new FactoryException(String.valueOf(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getOrCreate(String code, boolean create) throws FactoryException {
        Object value;
        block20: {
            String codespace = null;
            String version = null;
            String localCode = code;
            int afterAuthority = code.indexOf(58);
            int end = CharSequences.skipTrailingWhitespaces((CharSequence)code, (int)0, (int)afterAuthority);
            int start = CharSequences.skipLeadingWhitespaces((CharSequence)code, (int)0, (int)end);
            if (start < end) {
                codespace = code.substring(start, end);
                int afterVersion = code.indexOf(58, ++afterAuthority);
                start = CharSequences.skipLeadingWhitespaces((CharSequence)code, (int)afterAuthority, (int)afterVersion);
                if (start < (end = CharSequences.skipTrailingWhitespaces((CharSequence)code, (int)start, (int)afterVersion++))) {
                    version = code.substring(start, end);
                }
                start = Math.max(afterAuthority, afterVersion);
                end = code.length();
                localCode = CharSequences.trimWhitespaces((CharSequence)code, (int)start, (int)end).toString();
            }
            Disambiguation choices = null;
            value = null;
            this.lock.readLock().lock();
            try {
                boolean valid;
                boolean bl = valid = codespace == null || codespace.isEmpty() || this.codespaces.contains(codespace);
                if (!valid) {
                    String cs;
                    Iterator<String> iterator = this.codespaces.iterator();
                    while (iterator.hasNext() && !(valid = (cs = iterator.next()).equalsIgnoreCase(codespace))) {
                    }
                }
                if (valid && (value = this.definitions.get(localCode)) instanceof Disambiguation) {
                    choices = Disambiguation.find((Disambiguation)value, codespace, version, localCode);
                    value = choices != null ? choices.value : null;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            if (value == null) {
                DefaultIdentifier identifier = new DefaultIdentifier(codespace, localCode, version);
                String wkt = this.fetchDefinition(identifier);
                if (wkt != null) {
                    return this.parseAndAdd(codespace, version, localCode, wkt, identifier);
                }
                throw new NoSuchAuthorityCodeException(this.parser.errors().getString((short)95, (Object)code), codespace, localCode, code);
            }
            if (create && value instanceof StoredTree) {
                this.lock.writeLock().lock();
                try {
                    ParseException cause;
                    block21: {
                        value = choices != null ? choices.value : this.definitions.get(localCode);
                        if (!(value instanceof StoredTree)) break block20;
                        cause = null;
                        try {
                            value = this.parser.buildFromTree((StoredTree)value);
                            this.parser.logWarnings(WKTDictionary.class, "createObject");
                        }
                        catch (ParseException e) {
                            cause = e;
                            value = e.getLocalizedMessage();
                            if (value != null) break block21;
                            value = e.getClass().getSimpleName();
                        }
                    }
                    if (choices != null) {
                        choices.value = value;
                    } else {
                        this.definitions.put(localCode, value);
                    }
                    this.codeCaches.clear();
                    if (cause != null) {
                        throw new FactoryException(this.resources().getString((short)5, code), (Throwable)cause);
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }
        return value;
    }

    private final class Loader {
        private static final String SET = "SET";
        private final BufferedReader source;
        private final StringBuilder buffer;
        private String aliasKey;
        private final ParsePosition pos;
        private int lineNumber;
        private final Set<String> aliases;

        Loader(BufferedReader source) {
            this.source = source;
            this.buffer = new StringBuilder(500);
            this.pos = new ParsePosition(0);
            this.aliases = new HashSet<String>(WKTDictionary.this.parser.getFragmentNames());
        }

        final void restore() {
            WKTDictionary.this.parser.getFragmentNames().retainAll(this.aliases);
            WKTDictionary.this.parser.clear();
        }

        final String canNotRead(String cause, Exception e) {
            Locale locale = WKTDictionary.this.parser.getErrorLocale();
            if (cause == null) {
                cause = Exceptions.getLocalizedMessage((Throwable)e, (Locale)locale);
            }
            return Resources.forLocale(locale).getString((short)96, this.getLineNumber(), cause);
        }

        private int getLineNumber() {
            if (this.source instanceof LineNumberReader) {
                this.lineNumber = ((LineNumberReader)this.source).getLineNumber();
            }
            return this.lineNumber;
        }

        final void read() throws IOException, ParseException, FactoryDataException {
            String line;
            String lineSeparator = System.lineSeparator();
            int indentation = 0;
            while ((line = this.source.readLine()) != null) {
                int end;
                ++this.lineNumber;
                int length = line.length();
                int defStart = CharSequences.skipLeadingWhitespaces((CharSequence)line, (int)0, (int)length);
                if (defStart < length && line.charAt(defStart) == '#') continue;
                if (defStart > indentation) {
                    defStart = indentation;
                } else {
                    int keyStart;
                    this.addAliasOrDefinition();
                    indentation = defStart;
                    if (line.regionMatches(true, defStart, SET, 0, SET.length()) && (keyStart = CharSequences.skipLeadingWhitespaces((CharSequence)line, (int)(defStart + SET.length()), (int)length)) > defStart) {
                        defStart = line.indexOf(61, keyStart);
                        if (defStart <= keyStart) {
                            throw new FactoryDataException(WKTDictionary.this.resources().getString((short)97, this.getLineNumber()));
                        }
                        int keyEnd = CharSequences.skipTrailingWhitespaces((CharSequence)line, (int)keyStart, (int)defStart);
                        defStart = CharSequences.skipLeadingWhitespaces((CharSequence)line, (int)(defStart + 1), (int)length);
                        String key = line.substring(keyStart, keyEnd);
                        if (!CharSequences.isUnicodeIdentifier((CharSequence)key)) {
                            String c = WKTDictionary.this.parser.errors().getString((short)112, (Object)key);
                            throw new FactoryDataException(this.canNotRead(c, null));
                        }
                        this.aliasKey = key;
                    }
                }
                if (defStart >= (end = CharSequences.skipTrailingWhitespaces((CharSequence)line, (int)defStart, (int)length))) continue;
                if (this.buffer.length() != 0) {
                    this.buffer.append(lineSeparator);
                }
                this.buffer.append(line, defStart, end);
            }
            this.addAliasOrDefinition();
            WKTDictionary.this.parser.logWarnings(WKTDictionary.class, "load");
        }

        private void addAliasOrDefinition() throws ParseException, FactoryDataException {
            if (this.buffer.length() != 0) {
                this.pos.setIndex(0);
                String wkt = this.buffer.toString();
                StoredTree tree = WKTDictionary.this.parser.textToTree(wkt, this.pos, this.aliasKey);
                int end = this.pos.getIndex();
                if (end < wkt.length()) {
                    throw new FactoryDataException(WKTDictionary.this.unexpectedText(this.getLineNumber(), wkt, end));
                }
                if (this.aliasKey != null) {
                    WKTDictionary.this.parser.addFragment(this.aliasKey, tree);
                    this.aliasKey = null;
                } else {
                    WKTDictionary.this.addDefinition(tree);
                }
                this.buffer.setLength(0);
            }
        }
    }

    private static final class Disambiguation {
        private final Disambiguation previous;
        private final String codespace;
        private final String version;
        Object value;

        private Disambiguation(IdentifiedObject object) {
            ReferenceIdentifier id = (ReferenceIdentifier)CollectionsExt.first((Iterable)object.getIdentifiers());
            this.codespace = id.getCodeSpace();
            this.version = id.getVersion();
            this.value = object;
            this.previous = null;
        }

        private Disambiguation(StoredTree object) {
            Object[] fullId = new Object[3];
            object.peekIdentifiers(fullId);
            this.codespace = WKTDictionary.trimOrNull(fullId[0]);
            this.version = WKTDictionary.trimOrNull(fullId[2]);
            this.value = object;
            this.previous = null;
        }

        Disambiguation(String codespace, String version, String code, Object oldValue, Object newValue) {
            this.codespace = codespace;
            this.version = version;
            this.value = newValue;
            if (oldValue instanceof Disambiguation) {
                this.previous = (Disambiguation)oldValue;
            } else if (oldValue instanceof StoredTree) {
                this.previous = new Disambiguation((StoredTree)oldValue);
            } else if (oldValue instanceof IdentifiedObject) {
                this.previous = new Disambiguation((IdentifiedObject)oldValue);
            } else {
                this.previous = null;
                return;
            }
            Disambiguation check = this.previous;
            do {
                if (!Strings.equalsIgnoreCase((String)codespace, (String)check.codespace) || !Strings.equalsIgnoreCase((String)version, (String)check.version)) continue;
                throw new IllegalArgumentException(Errors.format((short)25, (Object)this.identifier(code)));
            } while ((check = check.previous) != null);
        }

        static Disambiguation find(Disambiguation choices, String codespace, String version, String code) throws NoSuchAuthorityCodeException {
            Disambiguation found = null;
            boolean isExact = false;
            while (choices != null) {
                block5: {
                    block7: {
                        block6: {
                            if (codespace != null && !codespace.equalsIgnoreCase(choices.codespace)) break block5;
                            if (!Strings.equalsIgnoreCase((String)version, (String)choices.version)) break block6;
                            if (isExact) break block7;
                            isExact = true;
                            found = choices;
                            break block5;
                        }
                        if (isExact) break block5;
                    }
                    if (isExact && found != null) {
                        String identifier = Disambiguation.identifier(codespace, version, code);
                        throw new NoSuchAuthorityCodeException(Errors.format((short)1, (Object)choices.identifier(code), (Object)found.identifier(code), (Object)identifier), codespace, code, identifier);
                    }
                    found = choices;
                }
                choices = choices.previous;
            }
            return found;
        }

        static void list(Disambiguation choices, String code, Predicate<Object> filter, Set<String> addTo) {
            do {
                if (!filter.test(choices.value)) continue;
                addTo.add(choices.identifier(code));
            } while ((choices = choices.previous) != null);
        }

        private String identifier(String code) {
            return Disambiguation.identifier(this.codespace, this.version, code);
        }

        private static String identifier(String codespace, String version, String code) {
            return Strings.orEmpty((String)codespace) + ":" + Strings.orEmpty((String)version) + ":" + Strings.orEmpty((String)code);
        }
    }
}

