/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.inflater;

import java.io.Closeable;
import java.io.IOException;
import java.nio.Buffer;
import java.util.Arrays;
import org.apache.sis.image.DataType;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.storage.UnsupportedEncodingException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.geotiff.inflater.CCITTRLE;
import org.apache.sis.storage.geotiff.inflater.CompressionChannel;
import org.apache.sis.storage.geotiff.inflater.CopyFromBytes;
import org.apache.sis.storage.geotiff.inflater.HorizontalPredictor;
import org.apache.sis.storage.geotiff.inflater.LZW;
import org.apache.sis.storage.geotiff.inflater.PackBits;
import org.apache.sis.storage.geotiff.inflater.PixelChannel;
import org.apache.sis.storage.geotiff.inflater.ZIP;
import org.apache.sis.storage.geotiff.internal.Compression;
import org.apache.sis.storage.geotiff.internal.Predictor;
import org.apache.sis.storage.geotiff.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.internal.Numerics;

public abstract class Inflater
implements Closeable {
    protected final ChannelDataInput input;
    protected final int chunksPerRow;
    protected final int elementsPerChunk;
    protected final int[] skipAfterChunks;

    protected Inflater(ChannelDataInput input, int chunksPerRow, int samplesPerChunk, int[] skipAfterChunks, int pixelsPerElement, int maxChunkSize) {
        this.input = input;
        ArgumentChecks.ensureStrictlyPositive((String)"chunksPerRow", (int)chunksPerRow);
        ArgumentChecks.ensureStrictlyPositive((String)"samplesPerChunk", (int)samplesPerChunk);
        ArgumentChecks.ensureStrictlyPositive((String)"pixelsPerElement", (int)pixelsPerElement);
        if (skipAfterChunks != null) {
            if (pixelsPerElement != 1) {
                skipAfterChunks = (int[])skipAfterChunks.clone();
                int i = 0;
                while (i < skipAfterChunks.length) {
                    int s = skipAfterChunks[i];
                    ArgumentChecks.ensurePositive((String)"skipAfterChunks", (int)s);
                    ArgumentChecks.ensureMultiple((String)"skipAfterChunks", (int)pixelsPerElement, (int)s);
                    int n = i++;
                    skipAfterChunks[n] = skipAfterChunks[n] / pixelsPerElement;
                }
            }
        } else {
            samplesPerChunk = Math.multiplyExact(samplesPerChunk, chunksPerRow);
            chunksPerRow = 1;
            if (samplesPerChunk > maxChunkSize) {
                int[] divisors = MathFunctions.divisors((int)samplesPerChunk);
                int i = Arrays.binarySearch(divisors, Numerics.ceilDiv((int)samplesPerChunk, (int)maxChunkSize));
                if (i < 0) {
                    i ^= 0xFFFFFFFF;
                }
                while (samplesPerChunk % ((chunksPerRow = divisors[i]) * pixelsPerElement) != 0 && ++i < divisors.length) {
                }
                samplesPerChunk /= chunksPerRow;
            }
        }
        if (chunksPerRow != 1) {
            ArgumentChecks.ensureDivisor((String)"pixelsPerElement", (int)samplesPerChunk, (int)pixelsPerElement);
        }
        this.elementsPerChunk = Numerics.ceilDiv((int)samplesPerChunk, (int)pixelsPerElement);
        this.skipAfterChunks = skipAfterChunks;
        this.chunksPerRow = chunksPerRow;
    }

    public static Inflater create(StoreListeners listeners, ChannelDataInput input, Compression compression, Predictor predictor, int sourcePixelStride, int sourceWidth, int chunksPerRow, int samplesPerChunk, int[] skipAfterChunks, int pixelsPerElement, DataType dataType) throws IOException, UnsupportedEncodingException {
        PixelChannel channel;
        CompressionChannel inflater;
        ArgumentChecks.ensureNonNull((String)"input", (Object)input);
        switch (compression) {
            case LZW: {
                inflater = new LZW(input, listeners);
                break;
            }
            case DEFLATE: {
                inflater = new ZIP(input, listeners);
                break;
            }
            case PACKBITS: {
                inflater = new PackBits(input, listeners);
                break;
            }
            case CCITTRLE: {
                inflater = new CCITTRLE(input, listeners, sourceWidth);
                break;
            }
            case NONE: {
                if (predictor == Predictor.NONE) {
                    return CopyFromBytes.create(input, dataType, chunksPerRow, samplesPerChunk, skipAfterChunks, pixelsPerElement);
                }
                throw Inflater.unsupportedEncoding(listeners, (short)30, predictor);
            }
            default: {
                throw Inflater.unsupportedEncoding(listeners, (short)27, compression);
            }
        }
        switch (predictor) {
            case NONE: {
                channel = inflater;
                break;
            }
            case HORIZONTAL: {
                if (sourceWidth == 1) {
                    channel = inflater;
                    break;
                }
                if (pixelsPerElement == 1 && (channel = HorizontalPredictor.create(inflater, dataType, sourcePixelStride, sourceWidth)) != null) break;
            }
            default: {
                throw Inflater.unsupportedEncoding(listeners, (short)30, predictor);
            }
        }
        int scanlineStride = Math.multiplyExact(sourceWidth, sourcePixelStride * dataType.bytes());
        return CopyFromBytes.create(inflater.createDataInput(channel, scanlineStride, compression.useNativeLibrary()), dataType, chunksPerRow, samplesPerChunk, skipAfterChunks, pixelsPerElement);
    }

    private static UnsupportedEncodingException unsupportedEncoding(StoreListeners listeners, short key, Enum<?> value) {
        return new UnsupportedEncodingException(Resources.forLocale(listeners.getLocale()).getString(key, value));
    }

    public void setInputOutput(long start, long byteCount, Buffer bank) throws IOException {
        if (this.input.channel instanceof PixelChannel) {
            ((PixelChannel)this.input.channel).setInputRegion(start, byteCount);
            this.input.buffer.limit(0);
            this.input.setStreamPosition(start);
        }
    }

    public abstract void skip(long var1) throws IOException;

    public abstract void uncompressRow() throws IOException;

    @Override
    public final void close() throws IOException {
        if (this.input.channel instanceof PixelChannel) {
            this.input.channel.close();
        }
    }
}

