/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import org.apache.gravitino.storage.relational.po.GroupPO;
import org.apache.gravitino.storage.relational.po.OwnerRelPO;
import org.apache.gravitino.storage.relational.po.UserPO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface OwnerMetaMapper {
    public static final String OWNER_TABLE_NAME = "owner_meta";

    @Select(value={"SELECT ut.user_id as userId, ut.user_name as userName, ut.metalake_id as metalakeId, ut.audit_info as auditInfo, ut.current_version as currentVersion, ut.last_version as lastVersion, ut.deleted_at as deletedAt FROM owner_meta ot JOIN user_meta ut ON ut.user_id = ot.owner_id WHERE ot.metadata_object_id = #{metadataObjectId} AND ot.metadata_object_type = #{metadataObjectType} AND ot.owner_type = 'USER' AND ot.deleted_at = 0 AND ut.deleted_at = 0"})
    public UserPO selectUserOwnerMetaByMetadataObjectIdAndType(@Param(value="metadataObjectId") Long var1, @Param(value="metadataObjectType") String var2);

    @Select(value={"SELECT gt.group_id as groupId, gt.group_name as groupName, gt.metalake_id as metalakeId, gt.audit_info as auditInfo, gt.current_version as currentVersion, gt.last_version as lastVersion, gt.deleted_at as deletedAt FROM owner_meta ot JOIN group_meta gt ON gt.group_id = ot.owner_id WHERE ot.metadata_object_id = #{metadataObjectId} AND ot.metadata_object_type = #{metadataObjectType} AND ot.owner_type = 'GROUP' AND ot.deleted_at = 0 AND gt.deleted_at = 0"})
    public GroupPO selectGroupOwnerMetaByMetadataObjectIdAndType(@Param(value="metadataObjectId") Long var1, @Param(value="metadataObjectType") String var2);

    @Insert(value={"INSERT INTO owner_meta(metalake_id, metadata_object_id, metadata_object_type, owner_id, owner_type, audit_info, current_version, last_version, deleted_at) VALUES ( #{ownerRelPO.metalakeId}, #{ownerRelPO.metadataObjectId}, #{ownerRelPO.metadataObjectType}, #{ownerRelPO.ownerId}, #{ownerRelPO.ownerType}, #{ownerRelPO.auditInfo}, #{ownerRelPO.currentVersion}, #{ownerRelPO.lastVersion}, #{ownerRelPO.deletedAt})"})
    public void insertOwnerRel(@Param(value="ownerRelPO") OwnerRelPO var1);

    @Update(value={"UPDATE owner_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metadata_object_id = #{metadataObjectId} AND metadata_object_type = #{metadataObjectType} AND deleted_at = 0"})
    public void softDeleteOwnerRelByMetadataObjectIdAndType(@Param(value="metadataObjectId") Long var1, @Param(value="metadataObjectType") String var2);

    @Update(value={"UPDATE owner_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE owner_id = #{ownerId} AND owner_type = #{ownerType} AND deleted_at = 0"})
    public void softDeleteOwnerRelByOwnerIdAndType(@Param(value="ownerId") Long var1, @Param(value="ownerType") String var2);

    @Update(value={"UPDATE  owner_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at =0"})
    public void softDeleteOwnerRelByMetalakeId(@Param(value="metalakeId") Long var1);

    @Update(value={"UPDATE  owner_meta ot SET ot.deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE EXISTS ( SELECT ct.catalog_id FROM catalog_meta ct WHERE ct.catalog_id = #{catalogId}  AND ct.deleted_at = 0 AND ot.deleted_at = 0 AND ct.catalog_id = ot.metadata_object_id AND ot.metadata_object_type = 'CATALOG' UNION  SELECT st.catalog_id FROM schema_meta st WHERE st.catalog_id = #{catalogId} AND st.deleted_at = 0 AND ot.deleted_at = 0 AND st.schema_id = ot.metadata_object_id AND ot.metadata_object_type = 'SCHEMA' UNION  SELECT tt.catalog_id FROM topic_meta tt WHERE tt.catalog_id = #{catalogId} AND tt.deleted_at = 0 AND ot.deleted_at = 0 AND tt.topic_id = ot.metadata_object_id AND ot.metadata_object_type = 'TOPIC' UNION  SELECT tat.catalog_id FROM table_meta tat WHERE tat.catalog_id = #{catalogId} AND tat.deleted_at = 0 AND ot.deleted_at = 0 AND tat.table_id = ot.metadata_object_id AND ot.metadata_object_type = 'TABLE' UNION  SELECT ft.catalog_id FROM fileset_meta ft WHERE ft.catalog_id = #{catalogId} AND ft.deleted_at = 0 AND ot.deleted_at = 0 AND ft.fileset_id = ot.metadata_object_id AND ot.metadata_object_type = 'FILESET')"})
    public void softDeleteOwnerRelByCatalogId(@Param(value="catalogId") Long var1);

    @Update(value={"UPDATE  owner_meta ot SET ot.deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE EXISTS ( SELECT st.schema_id FROM schema_meta st WHERE st.schema_id = #{schemaId} AND st.deleted_at = 0 AND ot.deleted_at = 0 AND st.schema_id = ot.metadata_object_id AND ot.metadata_object_type = 'SCHEMA' UNION  SELECT tt.schema_id FROM topic_meta tt WHERE tt.schema_id = #{schemaId} AND tt.deleted_at = 0 AND ot.deleted_at = 0 AND tt.topic_id = ot.metadata_object_id AND ot.metadata_object_type = 'TOPIC' UNION  SELECT tat.schema_id FROM table_meta tat WHERE tat.schema_id = #{schemaId} AND tat.deleted_at = 0 AND ot.deleted_at = 0 AND tat.table_id = ot.metadata_object_id AND ot.metadata_object_type = 'TABLE' UNION  SELECT ft.schema_id FROM fileset_meta ft WHERE ft.schema_id = #{schemaId} AND ft.deleted_at = 0 AND ot.deleted_at = 0 AND ft.fileset_id = ot.metadata_object_id AND ot.metadata_object_type = 'FILESET')"})
    public void sotDeleteOwnerRelBySchemaId(@Param(value="schemaId") Long var1);

    @Delete(value={"DELETE FROM owner_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}"})
    public Integer deleteOwnerMetasByLegacyTimeline(@Param(value="legacyTimeline") Long var1, @Param(value="limit") int var2);
}

