/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class MetalakePO {
    private Long metalakeId;
    private String metalakeName;
    private String metalakeComment;
    private String properties;
    private String auditInfo;
    private String schemaVersion;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;

    public Long getMetalakeId() {
        return this.metalakeId;
    }

    public String getMetalakeName() {
        return this.metalakeName;
    }

    public String getMetalakeComment() {
        return this.metalakeComment;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetalakePO)) {
            return false;
        }
        MetalakePO that = (MetalakePO)o;
        return Objects.equal((Object)this.getMetalakeId(), (Object)that.getMetalakeId()) && Objects.equal((Object)this.getMetalakeName(), (Object)that.getMetalakeName()) && Objects.equal((Object)this.getMetalakeComment(), (Object)that.getMetalakeComment()) && Objects.equal((Object)this.getProperties(), (Object)that.getProperties()) && Objects.equal((Object)this.getAuditInfo(), (Object)that.getAuditInfo()) && Objects.equal((Object)this.getSchemaVersion(), (Object)that.getSchemaVersion()) && Objects.equal((Object)this.getCurrentVersion(), (Object)that.getCurrentVersion()) && Objects.equal((Object)this.getLastVersion(), (Object)that.getLastVersion()) && Objects.equal((Object)this.getDeletedAt(), (Object)that.getDeletedAt());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getMetalakeId(), this.getMetalakeName(), this.getMetalakeComment(), this.getProperties(), this.getAuditInfo(), this.getSchemaVersion(), this.getCurrentVersion(), this.getLastVersion(), this.getDeletedAt()});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final MetalakePO metalakePO = new MetalakePO();

        private Builder() {
        }

        public Builder withMetalakeId(Long id) {
            this.metalakePO.metalakeId = id;
            return this;
        }

        public Builder withMetalakeName(String name) {
            this.metalakePO.metalakeName = name;
            return this;
        }

        public Builder withMetalakeComment(String comment) {
            this.metalakePO.metalakeComment = comment;
            return this;
        }

        public Builder withProperties(String properties) {
            this.metalakePO.properties = properties;
            return this;
        }

        public Builder withAuditInfo(String auditInfo) {
            this.metalakePO.auditInfo = auditInfo;
            return this;
        }

        public Builder withSchemaVersion(String version) {
            this.metalakePO.schemaVersion = version;
            return this;
        }

        public Builder withCurrentVersion(Long currentVersion) {
            this.metalakePO.currentVersion = currentVersion;
            return this;
        }

        public Builder withLastVersion(Long lastVersion) {
            this.metalakePO.lastVersion = lastVersion;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.metalakePO.deletedAt = deletedAt;
            return this;
        }

        private void validate() {
            Preconditions.checkArgument((this.metalakePO.metalakeId != null ? 1 : 0) != 0, (Object)"Metalake id is required");
            Preconditions.checkArgument((this.metalakePO.metalakeName != null ? 1 : 0) != 0, (Object)"Metalake name is required");
            Preconditions.checkArgument((this.metalakePO.auditInfo != null ? 1 : 0) != 0, (Object)"Audit info is required");
            Preconditions.checkArgument((this.metalakePO.schemaVersion != null ? 1 : 0) != 0, (Object)"Schema version is required");
            Preconditions.checkArgument((this.metalakePO.currentVersion != null ? 1 : 0) != 0, (Object)"Current version is required");
            Preconditions.checkArgument((this.metalakePO.lastVersion != null ? 1 : 0) != 0, (Object)"Last version is required");
            Preconditions.checkArgument((this.metalakePO.deletedAt != null ? 1 : 0) != 0, (Object)"Deleted at is required");
        }

        public MetalakePO build() {
            this.validate();
            return this.metalakePO;
        }
    }
}

