/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.TableEntity;
import org.apache.gravitino.storage.relational.mapper.OwnerMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TableMetaMapper;
import org.apache.gravitino.storage.relational.po.TablePO;
import org.apache.gravitino.storage.relational.service.CatalogMetaService;
import org.apache.gravitino.storage.relational.service.CommonMetaService;
import org.apache.gravitino.storage.relational.service.MetalakeMetaService;
import org.apache.gravitino.storage.relational.service.SchemaMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;

public class TableMetaService {
    private static final TableMetaService INSTANCE = new TableMetaService();

    public static TableMetaService getInstance() {
        return INSTANCE;
    }

    private TableMetaService() {
    }

    public TablePO getTablePOBySchemaIdAndName(Long schemaId, String tableName) {
        TablePO tablePO = SessionUtils.getWithoutCommit(TableMetaMapper.class, mapper -> mapper.selectTableMetaBySchemaIdAndName(schemaId, tableName));
        if (tablePO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.TABLE.name().toLowerCase(), tableName});
        }
        return tablePO;
    }

    public TablePO getTablePOById(Long tableId) {
        TablePO tablePO = SessionUtils.getWithoutCommit(TableMetaMapper.class, mapper -> mapper.selectTableMetaById(tableId));
        return tablePO;
    }

    public Long getTableIdBySchemaIdAndName(Long schemaId, String tableName) {
        Long tableId = SessionUtils.getWithoutCommit(TableMetaMapper.class, mapper -> mapper.selectTableIdBySchemaIdAndName(schemaId, tableName));
        if (tableId == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.TABLE.name().toLowerCase(), tableName});
        }
        return tableId;
    }

    public TableEntity getTableByIdentifier(NameIdentifier identifier) {
        NameIdentifierUtil.checkTable(identifier);
        Long schemaId = CommonMetaService.getInstance().getParentEntityIdByNamespace(identifier.namespace());
        TablePO tablePO = this.getTablePOBySchemaIdAndName(schemaId, identifier.name());
        return POConverters.fromTablePO(tablePO, identifier.namespace());
    }

    public List<TableEntity> listTablesByNamespace(Namespace namespace) {
        NamespaceUtil.checkTable(namespace);
        Long schemaId = CommonMetaService.getInstance().getParentEntityIdByNamespace(namespace);
        List tablePOs = SessionUtils.getWithoutCommit(TableMetaMapper.class, mapper -> mapper.listTablePOsBySchemaId(schemaId));
        return POConverters.fromTablePOs(tablePOs, namespace);
    }

    public void insertTable(TableEntity tableEntity, boolean overwrite) throws IOException {
        try {
            NameIdentifierUtil.checkTable(tableEntity.nameIdentifier());
            TablePO.Builder builder = TablePO.builder();
            this.fillTablePOBuilderParentEntityId(builder, tableEntity.namespace());
            SessionUtils.doWithCommit(TableMetaMapper.class, mapper -> {
                TablePO po = POConverters.initializeTablePOWithVersion(tableEntity, builder);
                if (overwrite) {
                    mapper.insertTableMetaOnDuplicateKeyUpdate(po);
                } else {
                    mapper.insertTableMeta(po);
                }
            });
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.TABLE, tableEntity.nameIdentifier().toString());
            throw re;
        }
    }

    public <E extends Entity & HasIdentifier> TableEntity updateTable(NameIdentifier identifier, Function<E, E> updater) throws IOException {
        Integer updateResult;
        NameIdentifierUtil.checkTable(identifier);
        String tableName = identifier.name();
        Long schemaId = CommonMetaService.getInstance().getParentEntityIdByNamespace(identifier.namespace());
        TablePO oldTablePO = this.getTablePOBySchemaIdAndName(schemaId, tableName);
        TableEntity oldTableEntity = POConverters.fromTablePO(oldTablePO, identifier.namespace());
        TableEntity newEntity = (TableEntity)updater.apply(oldTableEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldTableEntity.id(), newEntity.id()), (String)"The updated table entity id: %s should be same with the table entity id before: %s", (Object)newEntity.id(), (Object)oldTableEntity.id());
        try {
            updateResult = SessionUtils.doWithCommitAndFetchResult(TableMetaMapper.class, mapper -> mapper.updateTableMeta(POConverters.updateTablePOWithVersion(oldTablePO, newEntity), oldTablePO));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.TABLE, newEntity.nameIdentifier().toString());
            throw re;
        }
        if (updateResult > 0) {
            return newEntity;
        }
        throw new IOException("Failed to update the entity: " + identifier);
    }

    public boolean deleteTable(NameIdentifier identifier) {
        NameIdentifierUtil.checkTable(identifier);
        String tableName = identifier.name();
        Long schemaId = CommonMetaService.getInstance().getParentEntityIdByNamespace(identifier.namespace());
        Long tableId = this.getTableIdBySchemaIdAndName(schemaId, tableName);
        SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(TableMetaMapper.class, mapper -> mapper.softDeleteTableMetasByTableId(tableId)), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByMetadataObjectIdAndType(tableId, MetadataObject.Type.TABLE.name())));
        return true;
    }

    public int deleteTableMetasByLegacyTimeline(Long legacyTimeline, int limit) {
        return SessionUtils.doWithCommitAndFetchResult(TableMetaMapper.class, mapper -> mapper.deleteTableMetasByLegacyTimeline(legacyTimeline, limit));
    }

    private void fillTablePOBuilderParentEntityId(TablePO.Builder builder, Namespace namespace) {
        NamespaceUtil.checkTable(namespace);
        Long parentEntityId = null;
        block5: for (int level = 0; level < namespace.levels().length; ++level) {
            String name = namespace.level(level);
            switch (level) {
                case 0: {
                    parentEntityId = MetalakeMetaService.getInstance().getMetalakeIdByName(name);
                    builder.withMetalakeId(parentEntityId);
                    continue block5;
                }
                case 1: {
                    parentEntityId = CatalogMetaService.getInstance().getCatalogIdByMetalakeIdAndName(parentEntityId, name);
                    builder.withCatalogId(parentEntityId);
                    continue block5;
                }
                case 2: {
                    parentEntityId = SchemaMetaService.getInstance().getSchemaIdByCatalogIdAndName(parentEntityId, name);
                    builder.withSchemaId(parentEntityId);
                }
            }
        }
    }
}

