/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.iceberg.service.IcebergCatalogWrapperManager;
import org.apache.gravitino.iceberg.service.IcebergRestUtils;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;

@Path(value="/v1/{prefix:([^/]*/)?}namespaces/{namespace}/views")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IcebergViewOperations {
    private IcebergCatalogWrapperManager icebergCatalogWrapperManager;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public IcebergViewOperations(IcebergCatalogWrapperManager icebergCatalogWrapperManager) {
        this.icebergCatalogWrapperManager = icebergCatalogWrapperManager;
    }

    @GET
    @Produces(value={"application/json"})
    @Timed(name="list-view.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-view", absolute=true)
    public Response listView(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace) {
        ListTablesResponse response = this.icebergCatalogWrapperManager.getOps(prefix).listView(RESTUtil.decodeNamespace((String)namespace));
        return IcebergRestUtils.ok(response);
    }

    @POST
    @Produces(value={"application/json"})
    @Timed(name="create-view.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-view", absolute=true)
    public Response createView(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, CreateViewRequest request) {
        LoadViewResponse response = this.icebergCatalogWrapperManager.getOps(prefix).createView(RESTUtil.decodeNamespace((String)namespace), request);
        return IcebergRestUtils.ok(response);
    }

    @GET
    @Path(value="{view}")
    @Produces(value={"application/json"})
    @Timed(name="load-view.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="load-view", absolute=true)
    public Response loadView(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="view") String view) {
        TableIdentifier viewIdentifier = TableIdentifier.of((Namespace)RESTUtil.decodeNamespace((String)namespace), (String)view);
        LoadViewResponse response = this.icebergCatalogWrapperManager.getOps(prefix).loadView(viewIdentifier);
        return IcebergRestUtils.ok(response);
    }

    @POST
    @Path(value="{view}")
    @Produces(value={"application/json"})
    @Timed(name="replace-view.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="replace-view", absolute=true)
    public Response replaceView(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="view") String view, UpdateTableRequest request) {
        TableIdentifier viewIdentifier = TableIdentifier.of((Namespace)RESTUtil.decodeNamespace((String)namespace), (String)view);
        LoadViewResponse response = this.icebergCatalogWrapperManager.getOps(prefix).updateView(viewIdentifier, request);
        return IcebergRestUtils.ok(response);
    }

    @DELETE
    @Path(value="{view}")
    @Produces(value={"application/json"})
    @Timed(name="drop-view.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-view", absolute=true)
    public Response dropView(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="view") String view) {
        TableIdentifier viewIdentifier = TableIdentifier.of((Namespace)RESTUtil.decodeNamespace((String)namespace), (String)view);
        this.icebergCatalogWrapperManager.getOps(prefix).dropView(viewIdentifier);
        return IcebergRestUtils.noContent();
    }

    @HEAD
    @Path(value="{view}")
    @Produces(value={"application/json"})
    @Timed(name="view-exists.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="view-exits", absolute=true)
    public Response viewExists(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="view") String view) {
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)RESTUtil.decodeNamespace((String)namespace), (String)view);
        if (this.icebergCatalogWrapperManager.getOps(prefix).existView(tableIdentifier)) {
            return IcebergRestUtils.noContent();
        }
        return IcebergRestUtils.notExists();
    }
}

