/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import { defHttp } from '@/lib/utils/axios'

const Apis = {
  GET: ({ metalake, catalog, schema }) =>
    `/api/metalakes/${encodeURIComponent(metalake)}/catalogs/${encodeURIComponent(
      catalog
    )}/schemas/${encodeURIComponent(schema)}/topics`,
  GET_DETAIL: ({ metalake, catalog, schema, topic }) =>
    `/api/metalakes/${encodeURIComponent(metalake)}/catalogs/${encodeURIComponent(
      catalog
    )}/schemas/${encodeURIComponent(schema)}/topics/${encodeURIComponent(topic)}`,
  CREATE: ({ metalake, catalog, schema }) =>
    `/api/metalakes/${encodeURIComponent(metalake)}/catalogs/${encodeURIComponent(catalog)}/schemas/${encodeURIComponent(schema)}/topics`,
  UPDATE: ({ metalake, catalog, schema, topic }) =>
    `/api/metalakes/${encodeURIComponent(metalake)}/catalogs/${encodeURIComponent(catalog)}/schemas/${encodeURIComponent(schema)}/topics/${encodeURIComponent(topic)}`,
  DELETE: ({ metalake, catalog, schema, topic }) =>
    `/api/metalakes/${encodeURIComponent(metalake)}/catalogs/${encodeURIComponent(catalog)}/schemas/${encodeURIComponent(schema)}/topics/${encodeURIComponent(topic)}`
}

export const getTopicsApi = params => {
  return defHttp.get({
    url: `${Apis.GET(params)}`
  })
}

export const getTopicDetailsApi = ({ metalake, catalog, schema, topic }) => {
  return defHttp.get({
    url: `${Apis.GET_DETAIL({ metalake, catalog, schema, topic })}`
  })
}

export const createTopicApi = ({ metalake, catalog, schema, data }) => {
  return defHttp.post({ url: `${Apis.CREATE({ metalake, catalog, schema })}`, data })
}

export const updateTopicApi = ({ metalake, catalog, schema, topic, data }) => {
  return defHttp.put({ url: `${Apis.UPDATE({ metalake, catalog, schema, topic })}`, data })
}

export const deleteTopicApi = ({ metalake, catalog, schema, topic }) => {
  return defHttp.delete({ url: `${Apis.DELETE({ metalake, catalog, schema, topic })}` })
}
