/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.appender.self;

import com.alipay.common.tracer.core.appender.TraceAppender;
import com.alipay.common.tracer.core.appender.self.SelfLog;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class TracerDaemon
implements Runnable {
    private static final long ONE_HOUR = 3600L;
    private static AtomicBoolean running = new AtomicBoolean(false);
    private static List<TraceAppender> watchedAppenders = new CopyOnWriteArrayList<TraceAppender>();
    private static long scanInterval = 3600L;

    public static void watch(TraceAppender traceAppender) {
        watchedAppenders.add(traceAppender);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    for (TraceAppender traceAppender : watchedAppenders) {
                        traceAppender.cleanup();
                    }
                    TimeUnit.SECONDS.sleep(scanInterval);
                }
            }
            catch (Throwable e) {
                SelfLog.error("Error occurred while cleaning up logs.", e);
                continue;
            }
            break;
        }
    }

    public static void setScanInterval(long scanInterval) {
        TracerDaemon.scanInterval = scanInterval;
    }

    public static void start() {
        if (running.compareAndSet(false, true)) {
            Thread deleteLogThread = new Thread(new TracerDaemon());
            deleteLogThread.setDaemon(true);
            deleteLogThread.setName("Tracer-Daemon-Thread");
            deleteLogThread.start();
        }
    }
}

