/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.receiver;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.network.buffer.NetworkBuffer;
import org.apache.hugegraph.computer.core.receiver.MessageRecvPartition;
import org.apache.hugegraph.computer.core.receiver.MessageStat;
import org.apache.hugegraph.computer.core.sort.flusher.PeekableIterator;
import org.apache.hugegraph.computer.core.sort.sorting.SortManager;
import org.apache.hugegraph.computer.core.store.SuperstepFileGenerator;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;

public abstract class MessageRecvPartitions<P extends MessageRecvPartition> {
    protected final ComputerContext context;
    protected final Config config;
    protected final SuperstepFileGenerator fileGenerator;
    protected final SortManager sortManager;
    private final Map<Integer, P> partitions;

    public MessageRecvPartitions(ComputerContext context, SuperstepFileGenerator fileGenerator, SortManager sortManager) {
        this.context = context;
        this.config = context.config();
        this.fileGenerator = fileGenerator;
        this.sortManager = sortManager;
        this.partitions = new HashMap<Integer, P>();
    }

    protected abstract P createPartition();

    public void addBuffer(int partitionId, NetworkBuffer buffer) {
        P partition = this.partition(partitionId);
        ((MessageRecvPartition)partition).addBuffer(buffer);
    }

    public String genOutputPath(int partitionId) {
        P partition = this.partition(partitionId);
        String path = ((MessageRecvPartition)partition).genOutputPath();
        new File(path).getParentFile().mkdirs();
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private P partition(int partitionId) {
        MessageRecvPartition partition = (MessageRecvPartition)this.partitions.get(partitionId);
        if (partition == null) {
            Map<Integer, P> map = this.partitions;
            synchronized (map) {
                partition = (MessageRecvPartition)this.partitions.get(partitionId);
                if (partition == null) {
                    partition = this.createPartition();
                    this.partitions.put(partitionId, partition);
                }
            }
        }
        return (P)partition;
    }

    public Map<Integer, PeekableIterator<KvEntry>> iterators() {
        HashMap<Integer, PeekableIterator<KvEntry>> entries = new HashMap<Integer, PeekableIterator<KvEntry>>();
        for (Map.Entry<Integer, P> entry : this.partitions.entrySet()) {
            entries.put(entry.getKey(), ((MessageRecvPartition)entry.getValue()).iterator());
        }
        return entries;
    }

    public Map<Integer, MessageStat> messageStats() {
        HashMap<Integer, MessageStat> entries = new HashMap<Integer, MessageStat>();
        for (Map.Entry<Integer, P> entry : this.partitions.entrySet()) {
            entries.put(entry.getKey(), ((MessageRecvPartition)entry.getValue()).messageStat());
        }
        return entries;
    }

    public void clearOldFiles(int superstep) {
        MessageRecvPartition partition = this.partitions.values().stream().findFirst().orElse(null);
        if (partition != null) {
            List<String> dirs = this.fileGenerator.superstepDirs(superstep, partition.type());
            for (String dir : dirs) {
                FileUtils.deleteQuietly((File)new File(dir));
            }
        }
    }
}

