/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.rpc;

import java.net.InetSocketAddress;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.manager.Manager;
import org.apache.hugegraph.computer.core.rpc.AggregateRpcService;
import org.apache.hugegraph.computer.core.rpc.InputSplitRpcService;
import org.apache.hugegraph.rpc.RpcProviderConfig;
import org.apache.hugegraph.rpc.RpcServer;
import org.apache.hugegraph.util.E;

public class MasterRpcManager
implements Manager {
    public static final String NAME = "master_rpc";
    private RpcServer rpcServer = null;

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void init(Config config) {
        assert (this.rpcServer == null);
        this.rpcServer = new RpcServer(config.hugeConfig());
    }

    @Override
    public void close(Config config) {
        this.rpcServer.destroy();
    }

    public void registerInputSplitService(InputSplitRpcService service) {
        RpcProviderConfig serverConfig = this.rpcServer.config();
        serverConfig.addService(InputSplitRpcService.class, (Object)service);
    }

    public void registerAggregatorService(AggregateRpcService service) {
        RpcProviderConfig serverConfig = this.rpcServer.config();
        serverConfig.addService(AggregateRpcService.class, (Object)service);
    }

    public InetSocketAddress start() {
        E.checkNotNull((Object)this.rpcServer, (String)"rpcServer");
        try {
            this.rpcServer.exportAll();
            return InetSocketAddress.createUnresolved(this.rpcServer.host(), this.rpcServer.port());
        }
        catch (Throwable e) {
            this.rpcServer.destroy();
            throw new ComputerException("Failed to start rpc-server", e);
        }
    }
}

