/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.file.seqfile;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.io.AbstractBufferedFileInput;
import org.apache.hugegraph.computer.core.io.UnsafeBytesInput;
import org.apache.hugegraph.computer.core.store.file.seqfile.ValueFile;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.E;

public class ValueFileInput
extends AbstractBufferedFileInput {
    private final Config config;
    private final long maxSegmentSize;
    private final File dir;
    private final List<File> segments;
    private int segmentIndex;
    private RandomAccessFile currentSegment;

    public ValueFileInput(Config config, File dir) throws IOException {
        this(config, dir, 8192);
    }

    public ValueFileInput(Config config, File dir, int bufferCapacity) throws IOException {
        super(bufferCapacity, ValueFile.fileLength(dir));
        this.config = config;
        this.maxSegmentSize = (Long)config.get((TypedOption)ComputerOptions.VALUE_FILE_MAX_SEGMENT_SIZE);
        E.checkArgument((bufferCapacity >= 8 && (long)bufferCapacity <= this.maxSegmentSize ? 1 : 0) != 0, (String)"The parameter bufferSize must be >= 8 and <= %s", (Object[])new Object[]{this.maxSegmentSize});
        E.checkArgument((boolean)dir.isDirectory(), (String)"The parameter dir must be a directory", (Object[])new Object[0]);
        this.dir = dir;
        this.segments = ValueFile.scanSegment(dir);
        E.checkArgument((boolean)CollectionUtils.isNotEmpty(this.segments), (String)"Can't find any segment in dir '%s'", (Object[])new Object[]{dir.getAbsolutePath()});
        this.segmentIndex = -1;
        this.currentSegment = this.nextSegment();
        this.fileOffset = 0L;
        this.fillBuffer();
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int bufferRemain = super.remaining();
        int segmentRemain = this.currentSegmentRemain();
        if (bufferRemain >= len) {
            super.readFully(b, off, len);
        } else if (this.bufferCapacity() >= len) {
            this.shiftAndFillBuffer();
            super.readFully(b, off, len);
        } else if (bufferRemain + segmentRemain >= len) {
            super.readFully(b, off, bufferRemain);
            this.currentSegment.readFully(b, off + bufferRemain, len - bufferRemain);
            this.fileOffset += (long)(len - bufferRemain);
        } else {
            int offset = off;
            int length = len;
            super.readFully(b, offset, bufferRemain);
            length -= bufferRemain;
            this.currentSegment.readFully(b, offset += bufferRemain, segmentRemain);
            offset += segmentRemain;
            length -= segmentRemain;
            while (true) {
                this.currentSegment.close();
                this.currentSegment = this.nextSegment();
                if ((long)length <= this.maxSegmentSize) break;
                this.currentSegment.readFully(b, offset, (int)this.maxSegmentSize);
                offset = (int)((long)offset + this.maxSegmentSize);
                length = (int)((long)length - this.maxSegmentSize);
            }
            this.currentSegment.readFully(b, offset, length);
            this.fileOffset += (long)(len - bufferRemain);
        }
    }

    @Override
    public void seek(long position) throws IOException {
        if (position == this.position()) {
            return;
        }
        if (position > this.fileLength()) {
            throw new EOFException(String.format("Can't seek to %s, reach the end of file", position));
        }
        long bufferStart = this.fileOffset - (long)this.limit();
        if (bufferStart <= position && position <= this.fileOffset) {
            super.seek(position - bufferStart);
            return;
        }
        int segmentIndex = (int)(position / this.maxSegmentSize);
        if (segmentIndex != this.segmentIndex) {
            this.currentSegment.close();
            this.currentSegment = new RandomAccessFile(this.segments.get(segmentIndex), "r");
            this.segmentIndex = segmentIndex;
        }
        long seekPosition = position - (long)segmentIndex * this.maxSegmentSize;
        this.currentSegment.seek(seekPosition);
        super.seek(0L);
        this.limit(0);
        this.fileOffset = position;
        this.fillBuffer();
    }

    @Override
    public void close() throws IOException {
        this.currentSegment.close();
    }

    @Override
    protected void fillBuffer() throws IOException {
        int remain;
        int readLen = Math.min(this.bufferCapacity() - this.limit(), (int)(this.fileLength() - this.fileOffset));
        if (readLen <= (remain = this.currentSegmentRemain())) {
            this.currentSegment.readFully(this.buffer(), this.limit(), readLen);
        } else {
            this.currentSegment.readFully(this.buffer(), this.limit(), remain);
            this.currentSegment.close();
            this.currentSegment = this.nextSegment();
            this.currentSegment.readFully(this.buffer(), this.limit() + remain, readLen - remain);
        }
        this.fileOffset += (long)readLen;
        this.limit(this.limit() + readLen);
    }

    @Override
    public UnsafeBytesInput duplicate() throws IOException {
        ValueFileInput input = new ValueFileInput(this.config, this.dir, this.bufferCapacity());
        input.seek(this.position());
        return input;
    }

    private int currentSegmentRemain() throws IOException {
        long remain = this.maxSegmentSize - this.currentSegment.getFilePointer();
        return (int)remain;
    }

    private RandomAccessFile nextSegment() throws FileNotFoundException {
        File segment = this.segments.get(++this.segmentIndex);
        return new RandomAccessFile(segment, "r");
    }
}

