/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.util.E;

public class JsonUtil {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String toJson(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new ComputerException("Can't write json: %s", (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public static String toJsonWithClass(Object obj) {
        E.checkArgumentNotNull((Object)obj, (String)"The obj can't be null", (Object[])new Object[0]);
        return obj.getClass().getSimpleName() + JsonUtil.toJson(obj);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        E.checkState((json != null ? 1 : 0) != 0, (String)"Json value can't be null for '%s'", (Object[])new Object[]{clazz.getSimpleName()});
        try {
            return (T)OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw new ComputerException("Can't read json: %s", (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    static {
        OBJECT_MAPPER.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }
}

