/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.worker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hugegraph.computer.core.graph.partition.PartitionStat;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.io.Readable;
import org.apache.hugegraph.computer.core.io.Writable;
import org.apache.hugegraph.computer.core.util.JsonUtil;
import org.apache.hugegraph.util.E;

public class WorkerStat
implements Readable,
Writable,
Iterable<PartitionStat> {
    private int workerId;
    private List<PartitionStat> partitionStats;

    public WorkerStat() {
        this(0);
    }

    public WorkerStat(int workerId) {
        this.workerId = workerId;
        this.partitionStats = new ArrayList<PartitionStat>();
    }

    public int workerId() {
        return this.workerId;
    }

    public void add(PartitionStat stat) {
        E.checkArgumentNotNull((Object)stat, (String)"The stat can't be null", (Object[])new Object[0]);
        this.partitionStats.add(stat);
    }

    public PartitionStat get(int index) {
        return this.partitionStats.get(index);
    }

    public int size() {
        return this.partitionStats.size();
    }

    public void read(RandomAccessInput in) throws IOException {
        this.workerId = in.readInt();
        int size = in.readInt();
        this.partitionStats = new ArrayList<PartitionStat>(size);
        for (int i = 0; i < size; ++i) {
            PartitionStat stat = new PartitionStat();
            stat.read(in);
            this.partitionStats.add(stat);
        }
    }

    public void write(RandomAccessOutput out) throws IOException {
        out.writeInt(this.workerId);
        out.writeInt(this.partitionStats.size());
        for (PartitionStat stat : this.partitionStats) {
            stat.write(out);
        }
    }

    @Override
    public Iterator<PartitionStat> iterator() {
        return this.partitionStats.iterator();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WorkerStat)) {
            return false;
        }
        WorkerStat other = (WorkerStat)obj;
        return this.workerId == other.workerId && this.partitionStats.equals(other.partitionStats);
    }

    public int hashCode() {
        return Integer.hashCode(this.workerId);
    }

    public String toString() {
        return JsonUtil.toJsonWithClass(this);
    }
}

