/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.graph.value;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.graph.GraphFactory;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.value.ValueType;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;

public class IdSet
implements Value.Tvalue<Set<Id>> {
    private final GraphFactory graphFactory = ComputerContext.instance().graphFactory();
    private Set<Id> values = this.graphFactory.createSet();

    public void add(Id id) {
        this.values.add(id);
    }

    public void addAll(IdSet other) {
        this.values.addAll(other.values);
    }

    public void addAll(Collection<Id> other) {
        this.values.addAll(other);
    }

    public boolean contains(Id id) {
        return this.values.contains(id);
    }

    @Override
    public ValueType valueType() {
        return ValueType.ID_SET;
    }

    @Override
    public void assign(Value other) {
        this.checkAssign(other);
        this.values = ((IdSet)other).value();
    }

    @Override
    public IdSet copy() {
        IdSet values = new IdSet();
        for (Id value : this.values) {
            values.add((Id)value.copy());
        }
        return values;
    }

    @Override
    public void read(RandomAccessInput in) throws IOException {
        int size = in.readInt();
        if (size > this.values.size() || size < this.values.size() / 2) {
            this.values = this.graphFactory.createSet(size);
        } else {
            this.values.clear();
        }
        for (int i = 0; i < size; ++i) {
            Id id = this.graphFactory.createId();
            id.read(in);
            this.values.add(id);
        }
    }

    @Override
    public void write(RandomAccessOutput out) throws IOException {
        out.writeInt(this.values.size());
        for (Id id : this.values) {
            id.write(out);
        }
    }

    @Override
    public Set<Id> value() {
        return Collections.unmodifiableSet(this.values);
    }

    @Override
    public int compareTo(Value o) {
        throw new UnsupportedOperationException("compareTo");
    }
}

