/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.serializer.direct.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.exception.ServerException;
import org.apache.hugegraph.serializer.direct.util.HugeException;
import org.apache.hugegraph.structure.schema.EdgeLabel;
import org.apache.hugegraph.structure.schema.PropertyKey;
import org.apache.hugegraph.structure.schema.VertexLabel;

public class GraphSchema {
    private final HugeClient client;
    private final Map<String, PropertyKey> propertyKeys;
    private final Map<String, VertexLabel> vertexLabels;
    private final Map<String, EdgeLabel> edgeLabels;

    public GraphSchema(HugeClient client) {
        this.client = client;
        this.propertyKeys = new HashMap<String, PropertyKey>();
        this.vertexLabels = new HashMap<String, VertexLabel>();
        this.edgeLabels = new HashMap<String, EdgeLabel>();
        this.updateAll();
    }

    public void updateAll() {
        this.propertyKeys.clear();
        this.vertexLabels.clear();
        this.edgeLabels.clear();
        this.client.schema().getPropertyKeys().forEach(pk -> this.propertyKeys.put(pk.name(), (PropertyKey)pk));
        this.client.schema().getVertexLabels().forEach(vl -> this.vertexLabels.put(vl.name(), (VertexLabel)vl));
        this.client.schema().getEdgeLabels().forEach(el -> this.edgeLabels.put(el.name(), (EdgeLabel)el));
    }

    public PropertyKey getPropertyKey(String name) {
        PropertyKey propertyKey = this.propertyKeys.get(name);
        if (propertyKey == null) {
            try {
                propertyKey = this.client.schema().getPropertyKey(name);
            }
            catch (ServerException e) {
                throw new HugeException("The property key '%s' doesn't exist", name);
            }
        }
        return propertyKey;
    }

    public VertexLabel getVertexLabel(String name) {
        VertexLabel vertexLabel = this.vertexLabels.get(name);
        if (vertexLabel == null) {
            try {
                vertexLabel = this.client.schema().getVertexLabel(name);
            }
            catch (ServerException e) {
                throw new HugeException("The vertex label '%s' doesn't exist", name);
            }
        }
        return vertexLabel;
    }

    public EdgeLabel getEdgeLabel(String name) {
        EdgeLabel edgeLabel = this.edgeLabels.get(name);
        if (edgeLabel == null) {
            try {
                edgeLabel = this.client.schema().getEdgeLabel(name);
            }
            catch (ServerException e) {
                throw new HugeException("The edge label '%s' doesn't exist", name);
            }
        }
        return edgeLabel;
    }

    public EdgeLabel getEdgeLabel(int id) {
        for (EdgeLabel label : this.edgeLabels.values()) {
            if (label.id() != (long)id) continue;
            return label;
        }
        throw new HugeException("The edge label id '%s' doesn't exist", id);
    }
}

