/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.util.E;

public class Task {
    public static final long TASK_ID_NULL = 0L;
    @JsonProperty
    private long id;
    @JsonProperty(value="task_type")
    private String type;
    @JsonProperty(value="task_name")
    private String name;
    @JsonProperty(value="task_status")
    private String status;
    @JsonProperty(value="task_callable")
    private String callable;
    @JsonProperty(value="task_create")
    private long create;
    @JsonProperty(value="task_update")
    private long update;
    @JsonProperty(value="task_progress")
    private long progress;
    @JsonProperty(value="task_retries")
    private long retries;
    @JsonProperty(value="task_input")
    private String input;
    @JsonProperty(value="task_result")
    private Object result;
    @JsonProperty(value="task_description")
    private String description;
    @JsonProperty(value="task_dependencies")
    private Set<Long> dependencies;
    @JsonProperty(value="task_server")
    private String server;

    public long id() {
        return this.id;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String status() {
        return this.status;
    }

    public String callable() {
        return this.callable;
    }

    public long createTime() {
        return this.create;
    }

    public long updateTime() {
        return this.update;
    }

    public long progress() {
        return this.progress;
    }

    public long retries() {
        return this.retries;
    }

    public String input() {
        return this.input;
    }

    public Object result() {
        return this.result;
    }

    public String description() {
        return this.description;
    }

    public Set<Long> dependencies() {
        return this.dependencies;
    }

    public String server() {
        return this.server;
    }

    public boolean completed() {
        return ImmutableSet.of("success", "failed", "cancelled").contains(this.status);
    }

    public boolean cancelled() {
        return "cancelled".equals(this.status);
    }

    public boolean cancelling() {
        return "cancelling".equals(this.status);
    }

    public boolean success() {
        return "success".equals(this.status);
    }

    public Map<String, Object> asMap() {
        E.checkState(this.name != null, "Task name can't be null", new Object[0]);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.id);
        map.put("task_type", this.type);
        map.put("task_name", this.name);
        map.put("task_callable", this.callable);
        map.put("task_status", this.status);
        map.put("task_progress", this.progress);
        map.put("task_create", this.create);
        map.put("task_retries", this.retries);
        if (this.description != null) {
            map.put("task_description", this.description);
        }
        if (this.update != 0L) {
            map.put("task_update", this.update);
        }
        if (this.input != null) {
            map.put("task_input", this.input);
        }
        if (this.result != null) {
            map.put("task_result", this.result);
        }
        if (this.dependencies != null) {
            map.put("task_dependencies", this.dependencies);
        }
        if (this.server != null) {
            map.put("task_server", this.server);
        }
        return map;
    }

    public String toString() {
        return String.format("Task(id=%s)", this.id);
    }

    public static final class P {
        public static final String ID = "id";
        public static final String TYPE = "task_type";
        public static final String NAME = "task_name";
        public static final String CALLABLE = "task_callable";
        public static final String DESCRIPTION = "task_description";
        public static final String STATUS = "task_status";
        public static final String PROGRESS = "task_progress";
        public static final String CREATE = "task_create";
        public static final String UPDATE = "task_update";
        public static final String RETRIES = "task_retries";
        public static final String INPUT = "task_input";
        public static final String RESULT = "task_result";
        public static final String DEPENDENCIES = "task_dependencies";
        public static final String SERVER = "task_server";
    }
}

