/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.core.utils;

import com.ctrip.framework.apollo.core.utils.DeferredLogCache;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class DeferredLogger
implements Logger {
    private final Logger logger;
    private static final AtomicInteger state = new AtomicInteger(-1);

    public static void enable() {
        state.compareAndSet(-1, 1);
    }

    public static void disable() {
        state.set(0);
    }

    public static boolean isEnabled() {
        return state.get() == 1;
    }

    public static void replayTo() {
        DeferredLogger.disable();
        DeferredLogCache.replayTo();
    }

    public DeferredLogger(Logger logger) {
        this.logger = logger;
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String s) {
        this.logger.trace(s);
    }

    public void trace(String s, Object o) {
        this.logger.trace(s, o);
    }

    public void trace(String s, Object o, Object o1) {
        this.logger.trace(s, o, o1);
    }

    public void trace(String s, Object ... objects) {
        this.logger.trace(s, objects);
    }

    public void trace(String s, Throwable throwable) {
        this.logger.trace(s, throwable);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String s) {
        this.logger.trace(marker, s);
    }

    public void trace(Marker marker, String s, Object o) {
        this.logger.trace(marker, s, o);
    }

    public void trace(Marker marker, String s, Object o, Object o1) {
        this.logger.trace(marker, s, o, o1);
    }

    public void trace(Marker marker, String s, Object ... objects) {
        this.logger.trace(marker, s, objects);
    }

    public void trace(Marker marker, String s, Throwable throwable) {
        this.logger.trace(marker, s, throwable);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String s) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.debug(this.logger, s, new Object[0]);
        } else {
            this.logger.debug(s);
        }
    }

    public void debug(String s, Object o) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.debug(this.logger, s, o);
        } else {
            this.logger.debug(s, o);
        }
    }

    public void debug(String s, Object o, Object o1) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.debug(this.logger, s, o, o1);
        } else {
            this.logger.debug(s, o, o1);
        }
    }

    public void debug(String s, Object ... objects) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.debug(this.logger, s, objects);
        } else {
            this.logger.debug(s, objects);
        }
    }

    public void debug(String s, Throwable throwable) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.debug(this.logger, s, throwable);
        } else {
            this.logger.debug(s, throwable);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String s) {
        this.logger.debug(marker, s);
    }

    public void debug(Marker marker, String s, Object o) {
        this.logger.debug(marker, s, o);
    }

    public void debug(Marker marker, String s, Object o, Object o1) {
        this.logger.debug(marker, s, o, o1);
    }

    public void debug(Marker marker, String s, Object ... objects) {
        this.logger.debug(marker, s, objects);
    }

    public void debug(Marker marker, String s, Throwable throwable) {
        this.logger.debug(marker, s, throwable);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String s) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.info(this.logger, s, new Object[0]);
        } else {
            this.logger.info(s);
        }
    }

    public void info(String s, Object o) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.info(this.logger, s, o);
        } else {
            this.logger.info(s, o);
        }
    }

    public void info(String s, Object o, Object o1) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.info(this.logger, s, o, o1);
        } else {
            this.logger.info(s, o, o1);
        }
    }

    public void info(String s, Object ... objects) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.info(this.logger, s, objects);
        } else {
            this.logger.info(s, objects);
        }
    }

    public void info(String s, Throwable throwable) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.info(this.logger, s, throwable);
        } else {
            this.logger.info(s, throwable);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    public void info(Marker marker, String s) {
        this.logger.info(marker, s);
    }

    public void info(Marker marker, String s, Object o) {
        this.logger.info(marker, s, o);
    }

    public void info(Marker marker, String s, Object o, Object o1) {
        this.logger.info(marker, s, o, o1);
    }

    public void info(Marker marker, String s, Object ... objects) {
        this.logger.info(marker, s, objects);
    }

    public void info(Marker marker, String s, Throwable throwable) {
        this.logger.info(marker, s, throwable);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(String s) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.warn(this.logger, s, new Object[0]);
        } else {
            this.logger.warn(s);
        }
    }

    public void warn(String s, Object o) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.warn(this.logger, s, o);
        } else {
            this.logger.warn(s, o);
        }
    }

    public void warn(String s, Object ... objects) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.warn(this.logger, s, objects);
        } else {
            this.logger.warn(s, objects);
        }
    }

    public void warn(String s, Object o, Object o1) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.warn(this.logger, s, o, o1);
        } else {
            this.logger.warn(s, o, o1);
        }
    }

    public void warn(String s, Throwable throwable) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.warn(this.logger, s, throwable);
        } else {
            this.logger.warn(s, throwable);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String s) {
        this.logger.warn(marker, s);
    }

    public void warn(Marker marker, String s, Object o) {
        this.logger.warn(marker, s, o);
    }

    public void warn(Marker marker, String s, Object o, Object o1) {
        this.logger.warn(marker, s, o, o1);
    }

    public void warn(Marker marker, String s, Object ... objects) {
        this.logger.warn(marker, s, objects);
    }

    public void warn(Marker marker, String s, Throwable throwable) {
        this.logger.warn(marker, s, throwable);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(String s) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.error(this.logger, s, new Object[0]);
        } else {
            this.logger.error(s);
        }
    }

    public void error(String s, Object o) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.error(this.logger, s, o);
        } else {
            this.logger.error(s, o);
        }
    }

    public void error(String s, Object o, Object o1) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.error(this.logger, s, o, o1);
        } else {
            this.logger.error(s, o, o1);
        }
    }

    public void error(String s, Object ... objects) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.error(this.logger, s, objects);
        } else {
            this.logger.error(s, objects);
        }
    }

    public void error(String s, Throwable throwable) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.error(this.logger, s, throwable);
        } else {
            this.logger.error(s, throwable);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    public void error(Marker marker, String s) {
        this.logger.error(marker, s);
    }

    public void error(Marker marker, String s, Object o) {
        this.logger.error(marker, s, o);
    }

    public void error(Marker marker, String s, Object o, Object o1) {
        this.logger.error(marker, s, o, o1);
    }

    public void error(Marker marker, String s, Object ... objects) {
        this.logger.error(marker, s, objects);
    }

    public void error(Marker marker, String s, Throwable throwable) {
        this.logger.error(marker, s, throwable);
    }
}

