/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.LifeCycle;
import com.alipay.remoting.LifeCycleException;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractLifeCycle
implements LifeCycle {
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    @Override
    public void startup() throws LifeCycleException {
        if (this.isStarted.compareAndSet(false, true)) {
            return;
        }
        throw new LifeCycleException("this component has started");
    }

    @Override
    public void shutdown() throws LifeCycleException {
        if (this.isStarted.compareAndSet(true, false)) {
            return;
        }
        throw new LifeCycleException("this component has closed");
    }

    @Override
    public boolean isStarted() {
        return this.isStarted.get();
    }

    protected void ensureStarted() {
        if (!this.isStarted()) {
            throw new LifeCycleException(String.format("Component(%s) has not been started yet, please startup first!", this.getClass().getSimpleName()));
        }
    }
}

