/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.store.db.sql.log;

import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.core.store.db.sql.log.AbstractLogStoreSqls;

@LoadLevel(name="oracle")
public class OracleLogStoreSqls
extends AbstractLogStoreSqls {
    public static final String INSERT_GLOBAL_TRANSACTION_ORACLE = "insert into  #global_table# (xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified) values (?, ?, ?, ?, ?, ?, ?, ?, ?, sysdate, sysdate)";
    public static final String UPDATE_GLOBAL_TRANSACTION_STATUS_ORACLE = "update  #global_table#    set status = ?,       gmt_modified = sysdate where xid = ?";
    public static final String UPDATE_GLOBAL_TRANSACTION_STATUS_BY_STATUS_ORACLE = "update  #global_table#    set status = ?,       gmt_modified = sysdate where xid = ? and status = ?";
    public static final String QUERY_GLOBAL_TRANSACTION_BY_STATUS_ORACLE = "select A.* from ( select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified   from  #global_table#   where status in ( #PRAMETER_PLACEHOLD# )  order by gmt_modified ) A where ROWNUM <= ?";
    public static final String QUERY_GLOBAL_TRANSACTION_FOR_RECOVERY_ORACLE = "select A.* from ( select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified   from  #global_table#   where status in (0, 2, 3, 4, 5, 6, 7, 8, 10 ,12, 14)  order by gmt_modified ) A where ROWNUM <= ?";
    public static final String INSERT_BRANCH_TRANSACTION_ORACLE = "insert into  #branch_table# (xid, transaction_id, branch_id, resource_group_id, resource_id, branch_type, status, client_id, application_data, gmt_create, gmt_modified) values (?, ?, ?, ?, ?, ?, ?, ?, ?, systimestamp, systimestamp)";
    public static final String UPDATE_BRANCH_TRANSACTION_STATUS_ORACLE = "update  #branch_table#    set status = ?,       gmt_modified = systimestamp where xid = ?   and branch_id = ?";
    public static final String UPDATE_BRANCH_STATUS_APPLICATION_DATA_ORACLE = "update  #branch_table#    set status = ?,       application_data = ?,       gmt_modified = systimestamp where xid = ?   and branch_id = ?";

    @Override
    public String getInsertGlobalTransactionSQL(String globalTable) {
        return INSERT_GLOBAL_TRANSACTION_ORACLE.replace(" #global_table# ", globalTable);
    }

    @Override
    public String getUpdateGlobalTransactionStatusSQL(String globalTable) {
        return UPDATE_GLOBAL_TRANSACTION_STATUS_ORACLE.replace(" #global_table# ", globalTable);
    }

    @Override
    public String getUpdateGlobalTransactionStatusByStatusSQL(String globalTable) {
        return UPDATE_GLOBAL_TRANSACTION_STATUS_BY_STATUS_ORACLE.replace(" #global_table# ", globalTable);
    }

    @Override
    public String getQueryGlobalTransactionSQLByStatus(String globalTable, String paramsPlaceHolder) {
        return QUERY_GLOBAL_TRANSACTION_BY_STATUS_ORACLE.replace(" #global_table# ", globalTable).replace(" #PRAMETER_PLACEHOLD# ", paramsPlaceHolder);
    }

    @Override
    public String getQueryGlobalTransactionForRecoverySQL(String globalTable) {
        return QUERY_GLOBAL_TRANSACTION_FOR_RECOVERY_ORACLE.replace(" #global_table# ", globalTable);
    }

    @Override
    public String getInsertBranchTransactionSQL(String branchTable) {
        return INSERT_BRANCH_TRANSACTION_ORACLE.replace(" #branch_table# ", branchTable);
    }

    @Override
    public String getUpdateBranchTransactionStatusSQL(String branchTable) {
        return UPDATE_BRANCH_TRANSACTION_STATUS_ORACLE.replace(" #branch_table# ", branchTable);
    }

    @Override
    public String getUpdateBranchTransactionStatusAppDataSQL(String branchTable) {
        return UPDATE_BRANCH_STATUS_APPLICATION_DATA_ORACLE.replace(" #branch_table# ", branchTable);
    }
}

