/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.NullColumn;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;

public class DeviceViewOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(DeviceViewOperator.class);
    private final OperatorContext operatorContext;
    private final List<String> devices;
    private final List<Operator> deviceOperators;
    private final List<List<Integer>> deviceColumnIndex;
    private final List<TSDataType> dataTypes;
    private int deviceIndex;

    public DeviceViewOperator(OperatorContext operatorContext, List<String> devices, List<Operator> deviceOperators, List<List<Integer>> deviceColumnIndex, List<TSDataType> dataTypes) {
        this.operatorContext = operatorContext;
        this.devices = devices;
        this.deviceOperators = deviceOperators;
        this.deviceColumnIndex = deviceColumnIndex;
        this.dataTypes = dataTypes;
        this.deviceIndex = 0;
    }

    private String getCurDeviceName() {
        return this.devices.get(this.deviceIndex);
    }

    private Operator getCurDeviceOperator() {
        return this.deviceOperators.get(this.deviceIndex);
    }

    private List<Integer> getCurDeviceIndexes() {
        return this.deviceColumnIndex.get(this.deviceIndex);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.deviceIndex >= this.deviceOperators.size()) {
            return NOT_BLOCKED;
        }
        ListenableFuture<?> blocked = this.getCurDeviceOperator().isBlocked();
        if (!blocked.isDone()) {
            return blocked;
        }
        return NOT_BLOCKED;
    }

    @Override
    public TsBlock next() throws Exception {
        if (!this.getCurDeviceOperator().hasNextWithTimer()) {
            this.getCurDeviceOperator().close();
            this.deviceOperators.set(this.deviceIndex, null);
            ++this.deviceIndex;
            return null;
        }
        TsBlock tsBlock = this.getCurDeviceOperator().nextWithTimer();
        if (tsBlock == null) {
            return null;
        }
        List<Integer> indexes = this.getCurDeviceIndexes();
        Column[] newValueColumns = new Column[this.dataTypes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            newValueColumns[indexes.get((int)i).intValue()] = tsBlock.getColumn(i);
        }
        BinaryColumnBuilder deviceColumnBuilder = new BinaryColumnBuilder(null, 1);
        deviceColumnBuilder.writeBinary(new Binary(this.getCurDeviceName(), TSFileConfig.STRING_CHARSET));
        newValueColumns[0] = new RunLengthEncodedColumn(deviceColumnBuilder.build(), tsBlock.getPositionCount());
        for (int i = 0; i < this.dataTypes.size(); ++i) {
            if (newValueColumns[i] != null) continue;
            newValueColumns[i] = NullColumn.create((TSDataType)this.dataTypes.get(i), (int)tsBlock.getPositionCount());
        }
        return new TsBlock(tsBlock.getPositionCount(), tsBlock.getTimeColumn(), newValueColumns);
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.deviceIndex < this.devices.size();
    }

    @Override
    public void close() throws Exception {
        int n = this.deviceOperators.size();
        for (int i = this.deviceIndex; i < n; ++i) {
            Operator currentChild = this.deviceOperators.get(i);
            if (currentChild == null) continue;
            this.deviceOperators.get(i).close();
        }
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = this.calculateMaxReturnSize() + this.calculateRetainedSizeAfterCallingNext();
        for (Operator child : this.deviceOperators) {
            maxPeekMemory = Math.max(maxPeekMemory, child.calculateMaxPeekMemoryWithCounter());
        }
        return maxPeekMemory;
    }

    @Override
    public long calculateMaxReturnSize() {
        return (long)this.dataTypes.size() * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long max = 0L;
        for (Operator operator : this.deviceOperators) {
            max = Math.max(max, operator.calculateRetainedSizeAfterCallingNext());
        }
        return max;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + this.devices.stream().mapToLong(RamUsageEstimator::sizeOf).sum() + this.deviceOperators.stream().mapToLong(MemoryEstimationHelper::getEstimatedSizeOfAccountableObject).sum();
    }
}

