/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.airline.UsageHelper;
import io.airlift.airline.UsagePrinter;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class GlobalUsageSummary {
    private final int columnSize;

    public GlobalUsageSummary() {
        this(79);
    }

    public GlobalUsageSummary(int columnSize) {
        Preconditions.checkArgument((columnSize > 0 ? 1 : 0) != 0, (Object)"columnSize must be greater than 0");
        this.columnSize = columnSize;
    }

    public void usage(GlobalMetadata global) {
        StringBuilder stringBuilder = new StringBuilder();
        this.usage(global, stringBuilder);
        System.out.println(stringBuilder.toString());
    }

    public void usage(GlobalMetadata global, StringBuilder out) {
        this.usage(global, new UsagePrinter(out, this.columnSize));
    }

    public void usage(GlobalMetadata global, UsagePrinter out) {
        List commandArguments = (List)global.getOptions().stream().filter(option -> !option.isHidden()).map(UsageHelper::toUsage).collect(ImmutableList.toImmutableList());
        out.newPrinterWithHangingIndent(8).append("usage:").append(global.getName()).appendWords(commandArguments).append("<command> [<args>]").newline().newline();
        TreeMap<String, String> commands = new TreeMap<String, String>();
        for (CommandMetadata commandMetadata : global.getDefaultGroupCommands()) {
            if (commandMetadata.isHidden()) continue;
            commands.put(commandMetadata.getName(), commandMetadata.getDescription());
        }
        for (CommandGroupMetadata commandGroupMetadata : global.getCommandGroups()) {
            commands.put(commandGroupMetadata.getName(), commandGroupMetadata.getDescription());
        }
        out.append("The most commonly used ").append(global.getName()).append(" commands are:").newline();
        out.newIndentedPrinter(4).appendTable(commands.entrySet().stream().map(entry -> ImmutableList.of(entry.getKey(), (Object)MoreObjects.firstNonNull(entry.getValue(), (Object)""))).collect(Collectors.toList()));
        out.newline();
        out.append("See").append("'" + global.getName()).append("help <command>' for more information on a specific command.").newline();
    }
}

