/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.Map;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.jackrabbit.jcr2spi.ItemCache;
import org.apache.jackrabbit.jcr2spi.ItemImpl;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemCacheImpl
implements ItemCache {
    private static Logger log = LoggerFactory.getLogger(ItemCacheImpl.class);
    private final Map<ItemState, Item> cache;

    ItemCacheImpl(int maxSize) {
        this.cache = new LRUMap<ItemState, Item>(maxSize);
    }

    @Override
    public Item getItem(ItemState state) {
        return this.cache.get(state);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void itemCreated(Item item) {
        if (!(item instanceof ItemImpl)) {
            String msg = "Incompatible Item object: " + ItemImpl.class.getName() + " expected.";
            throw new IllegalArgumentException(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug("created item " + String.valueOf(item));
        }
        this.cacheItem(((ItemImpl)item).getItemState(), item);
    }

    @Override
    public void itemUpdated(Item item, boolean modified) {
        ItemState state;
        Item cacheEntry;
        if (!(item instanceof ItemImpl)) {
            String msg = "Incompatible Item object: " + ItemImpl.class.getName() + " expected.";
            throw new IllegalArgumentException(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug("update item " + String.valueOf(item));
        }
        if ((cacheEntry = this.getItem(state = ((ItemImpl)item).getItemState())) == null) {
            this.cacheItem(state, item);
        }
    }

    @Override
    public void itemDestroyed(Item item) {
        if (!(item instanceof ItemImpl)) {
            String msg = "Incompatible Item object: " + ItemImpl.class.getName() + " expected.";
            throw new IllegalArgumentException(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug("destroyed item " + String.valueOf(item));
        }
        ((ItemImpl)item).removeLifeCycleListener(this);
        this.evictItem(((ItemImpl)item).getItemState());
    }

    private synchronized void cacheItem(ItemState state, Item item) {
        if (this.cache.containsKey(state)) {
            log.warn("overwriting cached item " + String.valueOf(state));
        }
        if (log.isDebugEnabled()) {
            log.debug("caching item " + String.valueOf(state));
        }
        this.cache.put(state, item);
    }

    private synchronized void evictItem(ItemState itemState) {
        if (log.isDebugEnabled()) {
            log.debug("removing item " + String.valueOf(itemState) + " from cache");
        }
        this.cache.remove(itemState);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<ItemState, Item> entry : this.cache.entrySet()) {
            String path;
            ItemState state = entry.getKey();
            Item item = entry.getValue();
            if (item.isNode()) {
                builder.append("Node: ");
            } else {
                builder.append("Property: ");
            }
            if (item.isNew()) {
                builder.append("new ");
            } else if (item.isModified()) {
                builder.append("modified ");
            } else {
                builder.append("- ");
            }
            try {
                path = item.getPath();
            }
            catch (RepositoryException e) {
                path = "-";
            }
            builder.append(String.valueOf(state) + "\t" + path + " (" + String.valueOf(item) + ")\n");
        }
        return builder.toString();
    }
}

