/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.query;

import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public abstract class AbstractQuery
implements Command {
    private String statementKey = "statement";
    private String destKey = "collected";

    @Override
    public final boolean execute(Context ctx) throws Exception {
        String statement = (String)ctx.get(this.statementKey);
        Session session = CommandHelper.getSession(ctx);
        Query query = session.getWorkspace().getQueryManager().createQuery(statement, this.getLanguage());
        QueryResult result = query.execute();
        ctx.put(this.destKey, result.getNodes());
        return false;
    }

    protected abstract String getLanguage();

    public String getStatementKey() {
        return this.statementKey;
    }

    public void setStatementKey(String statementKey) {
        this.statementKey = statementKey;
    }

    public String getDestKey() {
        return this.destKey;
    }

    public void setDestKey(String toKey) {
        this.destKey = toKey;
    }
}

