/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.events;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.UUID;
import org.apache.james.core.User;

public interface Event {
    public User getUser();

    public boolean isNoop();

    public EventId getEventId();

    public static class EventId {
        private final UUID id;

        public static EventId of(UUID uuid) {
            return new EventId(uuid);
        }

        public static EventId random() {
            return new EventId(UUID.randomUUID());
        }

        public static EventId of(String serialized) {
            return EventId.of(UUID.fromString(serialized));
        }

        private EventId(UUID id) {
            Preconditions.checkNotNull(id);
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public final boolean equals(Object o) {
            if (o instanceof EventId) {
                EventId eventId = (EventId)o;
                return Objects.equals(this.id, eventId.id);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("id", this.id).toString();
        }
    }
}

