/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.blob.deduplication;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.ByteSource;
import com.google.common.io.FileBackedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.server.blob.deduplication.DeDuplicationBlobStore$;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.util.function.Tuples;
import scala.Function1;
import scala.compat.java8.FunctionConverters.package$;
import scala.compat.java8.functionConverterImpls.RichFunction1AsConsumer$;
import scala.compat.java8.functionConverterImpls.RichFunction1AsFunction$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005-w!B\f\u0019\u0011\u0003)c!B\u0014\u0019\u0011\u0003A\u0003\"B\u0018\u0002\t\u0003\u0001\u0004bB\u0019\u0002\u0005\u0004%\tA\r\u0005\u0007m\u0005\u0001\u000b\u0011B\u001a\t\u000f]\n!\u0019!C\u0001q!1A(\u0001Q\u0001\ne2Aa\n\r\u0001{!AQj\u0002B\u0001B\u0003%a\n\u0003\u0005R\u000f\t\u0005\t\u0015!\u0003S\u0011!\twA!A!\u0002\u0013\u0011\u0007\"B\u0018\b\t\u0003I\u0007\"B:\b\t\u0003\"\bBB:\b\t\u0003\n\u0019\u0003\u0003\u0004t\u000f\u0011\u0005\u00131\t\u0005\b\u0003+:A\u0011BA,\u0011\u001d\tYi\u0002C!\u0003\u001bCq!a&\b\t\u0003\nI\nC\u0004\u0002 \u001e!\t%!)\t\u000f\u0005\rv\u0001\"\u0011\u0002&\"9\u0011\u0011W\u0004\u0005B\u0005M\u0006bBA`\u000f\u0011\u0005\u0013\u0011\u0019\u0005\b\u0003\u000b<A\u0011IAd\u0003Y!U\rR;qY&\u001c\u0017\r^5p]\ncwNY*u_J,'BA\r\u001b\u00035!W\rZ;qY&\u001c\u0017\r^5p]*\u00111\u0004H\u0001\u0005E2|'M\u0003\u0002\u001e=\u000511/\u001a:wKJT!a\b\u0011\u0002\u000b)\fW.Z:\u000b\u0005\u0005\u0012\u0013AB1qC\u000eDWMC\u0001$\u0003\ry'oZ\u0002\u0001!\t1\u0013!D\u0001\u0019\u0005Y!U\rR;qY&\u001c\u0017\r^5p]\ncwNY*u_J,7CA\u0001*!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!J\u0001\u0016\u0019\u0006S\u0016l\u0018*F'>+&kQ#`\u00072+\u0015IT+Q+\u0005\u0019\u0004C\u0001\u00165\u0013\t)4FA\u0004C_>dW-\u00198\u0002-1\u000b%,W0S\u000bN{UKU\"F?\u000ecU)\u0011(V!\u0002\naBR%M\u000b~#\u0006JU#T\u0011>cE)F\u0001:!\tQ#(\u0003\u0002<W\t\u0019\u0011J\u001c;\u0002\u001f\u0019KE*R0U\u0011J+5\u000bS(M\t\u0002\u001a2a\u0002 G!\tyD)D\u0001A\u0015\t\t%)\u0001\u0003mC:<'\"A\"\u0002\t)\fg/Y\u0005\u0003\u000b\u0002\u0013aa\u00142kK\u000e$\bCA$L\u001b\u0005A%BA%K\u0003\r\t\u0007/\u001b\u0006\u00037yI!\u0001\u0014%\u0003\u0013\tcwNY*u_J,\u0017\u0001\u00042m_\n\u001cFo\u001c:f\t\u0006{\u0005CA$P\u0013\t\u0001\u0006J\u0001\u0007CY>\u00147\u000b^8sK\u0012\u000bu*A\teK\u001a\fW\u000f\u001c;Ck\u000e\\W\r\u001e(b[\u0016\u0004\"aR*\n\u0005QC%A\u0003\"vG.,GOT1nK\"\"\u0011B\u00160`!\t9F,D\u0001Y\u0015\tI&,\u0001\u0004j]*,7\r\u001e\u0006\u00027\u0006)!.\u0019<bq&\u0011Q\f\u0017\u0002\u0006\u001d\u0006lW\rZ\u0001\u0006m\u0006dW/Z\u0011\u0002A\u0006iA-\u001a4bk2$()^2lKR\fQB\u00197pE&#g)Y2u_JL\bCA2g\u001d\t9E-\u0003\u0002f\u0011\u00061!\t\\8c\u0013\u0012L!a\u001a5\u0003\u000f\u0019\u000b7\r^8ss*\u0011Q\r\u0013\u000b\u0005U.dg\u000e\u0005\u0002'\u000f!)Qj\u0003a\u0001\u001d\")\u0011k\u0003a\u0001%\"\"AN\u00160`\u0011\u0015\t7\u00021\u0001cQ\tY\u0001\u000f\u0005\u0002Xc&\u0011!\u000f\u0017\u0002\u0007\u0013:TWm\u0019;\u0002\tM\fg/\u001a\u000b\u0007kz\f\t!!\u0005\u0011\u0007YL80D\u0001x\u0015\tA(%A\bsK\u0006\u001cG/\u001b<fgR\u0014X-Y7t\u0013\tQxOA\u0005Qk\nd\u0017n\u001d5feB\u0011q\t`\u0005\u0003{\"\u0013aA\u00117pE&#\u0007\"B@\r\u0001\u0004\u0011\u0016A\u00032vG.,GOT1nK\"9\u00111\u0001\u0007A\u0002\u0005\u0015\u0011\u0001\u00023bi\u0006\u0004RAKA\u0004\u0003\u0017I1!!\u0003,\u0005\u0015\t%O]1z!\rQ\u0013QB\u0005\u0004\u0003\u001fY#\u0001\u0002\"zi\u0016Dq!a\u0005\r\u0001\u0004\t)\"A\u0007ti>\u0014\u0018mZ3Q_2L7-\u001f\t\u0005\u0003/\tiBD\u0002H\u00033I1!a\u0007I\u0003%\u0011En\u001c2Ti>\u0014X-\u0003\u0003\u0002 \u0005\u0005\"!D*u_J\fw-\u001a)pY&\u001c\u0017PC\u0002\u0002\u001c!#r!^A\u0013\u0003O\t\t\u0005C\u0003\u0000\u001b\u0001\u0007!\u000bC\u0004\u0002\u00045\u0001\r!!\u000b\u0011\t\u0005-\u0012QH\u0007\u0003\u0003[QA!a\f\u00022\u0005\u0011\u0011n\u001c\u0006\u0005\u0003g\t)$\u0001\u0004d_6lwN\u001c\u0006\u0005\u0003o\tI$\u0001\u0004h_><G.\u001a\u0006\u0003\u0003w\t1aY8n\u0013\u0011\ty$!\f\u0003\u0015\tKH/Z*pkJ\u001cW\rC\u0004\u0002\u00145\u0001\r!!\u0006\u0015\u000fU\f)%a\u0012\u0002T!)qP\u0004a\u0001%\"9\u00111\u0001\bA\u0002\u0005%\u0003\u0003BA&\u0003\u001fj!!!\u0014\u000b\u0007\u0005=\")\u0003\u0003\u0002R\u00055#aC%oaV$8\u000b\u001e:fC6Dq!a\u0005\u000f\u0001\u0004\t)\"A\u000btCZ,\u0017I\u001c3HK:,'/\u0019;f\u00052|'-\u00133\u0015\u0011\u0005e\u0013qNA9\u0003\u0003\u0003R!a\u0017\u0002lml!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\naV\u0014G.[:iKJT1\u0001LA2\u0015\u0011\t)'a\u001a\u0002\t\r|'/\u001a\u0006\u0003\u0003S\nqA]3bGR|'/\u0003\u0003\u0002n\u0005u#!B*N_:|\u0007\"B@\u0010\u0001\u0004\u0011\u0006bBA:\u001f\u0001\u0007\u0011QO\u0001\u0013Q\u0006\u001c\b.\u001b8h\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0005\u0003\u0002x\u0005uTBAA=\u0015\u0011\tY(!\r\u0002\t!\f7\u000f[\u0005\u0005\u0003\u007f\nIH\u0001\nICND\u0017N\\4J]B,Ho\u0015;sK\u0006l\u0007bBAB\u001f\u0001\u0007\u0011QQ\u0001\u0017M&dWMQ1dW\u0016$w*\u001e;qkR\u001cFO]3b[B!\u00111FAD\u0013\u0011\tI)!\f\u0003-\u0019KG.\u001a\"bG.,GmT;uaV$8\u000b\u001e:fC6\f\u0011B]3bI\nKH/Z:\u0015\r\u0005=\u0015\u0011SAJ!\u00111\u00180!\u0002\t\u000b}\u0004\u0002\u0019\u0001*\t\r\u0005U\u0005\u00031\u0001|\u0003\u0019\u0011Gn\u001c2JI\u0006!!/Z1e)\u0019\tI%a'\u0002\u001e\")q0\u0005a\u0001%\"1\u0011QS\tA\u0002m\fAcZ3u\t\u00164\u0017-\u001e7u\u0005V\u001c7.\u001a;OC6,G#\u0001*\u0002\u0019\u0011,G.\u001a;f\u0005V\u001c7.\u001a;\u0015\t\u0005\u001d\u0016q\u0016\t\u0005mf\fI\u000bE\u0002@\u0003WK1!!,A\u0005\u00111v.\u001b3\t\u000b}\u001c\u0002\u0019\u0001*\u0002\r\u0011,G.\u001a;f)\u0019\t),a/\u0002>B!a/_A\\!\ry\u0014\u0011X\u0005\u0003k\u0001CQa \u000bA\u0002ICa!!&\u0015\u0001\u0004Y\u0018a\u00037jgR\u0014UoY6fiN$\"!a1\u0011\u0007YL(+A\u0005mSN$(\t\\8cgR\u0019Q/!3\t\u000b}4\u0002\u0019\u0001*")
public class DeDuplicationBlobStore
implements BlobStore {
    private final BlobStoreDAO blobStoreDAO;
    @Named(value="defaultBucket")
    private final BucketName defaultBucketName;
    private final BlobId.Factory blobIdFactory;

    public static int FILE_THRESHOLD() {
        return DeDuplicationBlobStore$.MODULE$.FILE_THRESHOLD();
    }

    public static boolean LAZY_RESOURCE_CLEANUP() {
        return DeDuplicationBlobStore$.MODULE$.LAZY_RESOURCE_CLEANUP();
    }

    public Publisher<BlobId> save(BucketName x$1, String x$2, BlobStore.StoragePolicy x$3) {
        return super.save(x$1, x$2, x$3);
    }

    public Publisher<byte[]> readBytes(BucketName x$1, BlobId x$2, BlobStore.StoragePolicy x$3) {
        return super.readBytes(x$1, x$2, x$3);
    }

    public InputStream read(BucketName x$1, BlobId x$2, BlobStore.StoragePolicy x$3) {
        return super.read(x$1, x$2, x$3);
    }

    public Publisher<BlobId> save(BucketName bucketName, byte[] data, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        BlobId blobId = this.blobIdFactory.forPayload(data);
        return SMono$.MODULE$.apply(this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just((Object)blobId));
    }

    public Publisher<BlobId> save(BucketName bucketName, ByteSource data, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        BlobId blobId = this.blobIdFactory.forPayload(data);
        return SMono$.MODULE$.apply(this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just((Object)blobId));
    }

    public Publisher<BlobId> save(BucketName bucketName, InputStream data, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        HashingInputStream hashingInputStream = new HashingInputStream(Hashing.sha256(), data);
        Function1 & Serializable sourceSupplier = (Function1 & Serializable)fileBackedOutputStream -> this.saveAndGenerateBlobId(bucketName, hashingInputStream, (FileBackedOutputStream)fileBackedOutputStream).asJava();
        Callable<FileBackedOutputStream> ressourceSupplier = () -> new FileBackedOutputStream(DeDuplicationBlobStore$.MODULE$.FILE_THRESHOLD());
        return Mono.using(ressourceSupplier, (Function)RichFunction1AsFunction$.MODULE$.asJava$extension(package$.MODULE$.enrichAsJavaFunction((Function1)sourceSupplier)), (Consumer)RichFunction1AsConsumer$.MODULE$.asJava$extension(package$.MODULE$.enrichAsJavaConsumer((Function1 & Serializable)fileBackedOutputStream -> {
            fileBackedOutputStream.reset();
            return BoxedUnit.UNIT;
        })), (boolean)DeDuplicationBlobStore$.MODULE$.LAZY_RESOURCE_CLEANUP());
    }

    private SMono<BlobId> saveAndGenerateBlobId(BucketName bucketName, HashingInputStream hashingInputStream, FileBackedOutputStream fileBackedOutputStream) {
        return SMono$.MODULE$.fromCallable(() -> {
            IOUtils.copy((InputStream)hashingInputStream, (OutputStream)fileBackedOutputStream);
            return Tuples.of((Object)$this.blobIdFactory.from(hashingInputStream.hash().toString()), (Object)fileBackedOutputStream.asByteSource());
        }).flatMap((Function1 & Serializable)tuple -> SMono$.MODULE$.apply($this.blobStoreDAO.save(bucketName, (BlobId)tuple.getT1(), (ByteSource)tuple.getT2())).then(SMono$.MODULE$.just(tuple.getT1())));
    }

    public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.readBytes(bucketName, blobId);
    }

    public InputStream read(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.read(bucketName, blobId);
    }

    public BucketName getDefaultBucketName() {
        return this.defaultBucketName;
    }

    public Publisher<Void> deleteBucket(BucketName bucketName) {
        return this.blobStoreDAO.deleteBucket(bucketName);
    }

    public Publisher<Boolean> delete(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)blobId);
        return SMono$.MODULE$.just((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public Publisher<BucketName> listBuckets() {
        return Flux.concat((Publisher[])new Publisher[]{this.blobStoreDAO.listBuckets(), Flux.just((Object)this.defaultBucketName)}).distinct();
    }

    public Publisher<BlobId> listBlobs(BucketName bucketName) {
        return this.blobStoreDAO.listBlobs(bucketName);
    }

    @Inject
    public DeDuplicationBlobStore(BlobStoreDAO blobStoreDAO, @Named(value="defaultBucket") BucketName defaultBucketName, BlobId.Factory blobIdFactory) {
        this.blobStoreDAO = blobStoreDAO;
        this.defaultBucketName = defaultBucketName;
        this.blobIdFactory = blobIdFactory;
    }
}

